#NoTrayIcon
#Region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_Icon=Icon256-32.ico
#AutoIt3Wrapper_Outfile=BackupExecPS.exe
#AutoIt3Wrapper_Outfile_x64=BackupExecPS64.exe
#AutoIt3Wrapper_Compile_Both=y
#AutoIt3Wrapper_UseX64=y
#AutoIt3Wrapper_Change2CUI=y
#AutoIt3Wrapper_Res_Description=Zabbix BackupExec Job Monitoring
#AutoIt3Wrapper_Res_Fileversion=1.0.0.8
#AutoIt3Wrapper_Res_Fileversion_AutoIncrement=y
#AutoIt3Wrapper_Res_LegalCopyright=2016 Bernhard Linz
#AutoIt3Wrapper_Res_SaveSource=y
#AutoIt3Wrapper_Res_Language=1031
#AutoIt3Wrapper_Res_Field=Website|http://znil.net
#AutoIt3Wrapper_Res_Field=Manual|http://znil.net/index.php?title=Zabbix:Template_BackupExec_PS_Jobs
#AutoIt3Wrapper_Res_Field=See You|znil.net
#EndRegion ;**** Directives created by AutoIt3Wrapper_GUI ****
Opt('MustDeclareVars', 1)
#Region    ;************ Includes ************
#Include <Array.au3>
#include <Constants.au3>
#include <Date.au3>
#EndRegion ;************ Includes ************
; ##########################################################################################################################
; ##########################################################################################################################
; # backupexecPS.exe --> Tool for Check BackupJobs in Zabbix                                                               #
; # 2014 - 2016 Bernhard Linz    /    Bernhard@znil.de    /    http://znil.net                                             #
; # Idea and Original at Zabbix Wiki                                                                                       #
; #                                                                                                                        #
; # Latest Version of this Program and Template in German:                                                                 #
; # http://znil.net/index.php?title=Zabbix:Template_BackupExec_PS_Jobs                                                   #
; #                                                                                                                        #
; #	         ________  .__   __.  __   __        .__   __.  _______ .___________.                                          #
; #	        |       /  |  \ |  | |  | |  |       |  \ |  | |   ____||           |                                          #
; #	        `---/  /   |   \|  | |  | |  |       |   \|  | |  |__   `---|  |----`                                          #
; #	           /  /    |  . `  | |  | |  |       |  . `  | |   __|      |  |                                               #
; #	          /  /----.|  |\   | |  | |  `----.__|  |\   | |  |____     |  |                                               #
; #	         /________||__| \__| |__| |_______(__)__| \__| |_______|    |__|                                               #
; #                                                                                                                        #
; ##########################################################################################################################
; ##########################################################################################################################

; find the 'BEMCLI.exe' - take a look at Registry of Host
Dim $SoftwareBasePaths[9] = ["HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\Symantec Backup Exec 14.2", _
							 "HKLM64\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\Symantec Backup Exec 14.2", _
							 "HKLM\SOFTWARE\Wow6432Node\Microsoft\Windows\CurrentVersion\Uninstall\Symantec Backup Exec 14.2", _
							 "HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\Symantec Backup Exec 14.1", _
							 "HKLM64\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\Symantec Backup Exec 14.1", _
							 "HKLM\SOFTWARE\Wow6432Node\Microsoft\Windows\CurrentVersion\Uninstall\Symantec Backup Exec 14.1", _
							 "HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\Symantec Backup Exec 14.0", _
							 "HKLM64\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\Symantec Backup Exec 14.0", _
							 "HKLM\SOFTWARE\Wow6432Node\Microsoft\Windows\CurrentVersion\Uninstall\Symantec Backup Exec 14.0"]
Global $bemcli
Dim $aparameter[4]
	$aparameter[0] = "Get-BEJob -JobType Backup,Duplicate -Status Scheduled,Active,Linked | select-object -property *" 	; get a List of scheduled and active jobs
	$aparameter[1] = "Get-BEJob -JobType Duplicate -Status Linked | select-object -property *" 							; get a list of Duplicate Jobs
	$aparameter[2] = '-o21 -e -j"Name of Job"'																			; get last Exit-Code of a specific job by Name
	$aparameter[3] = 'Get-BEJob -Id {ID of Job} | Get-BEJobHistory -FromLastJobRun | select-object -property *'			; get last Exit-Code of a specific job by ID

Dim $stemp
Dim $atemp
Dim $aatemp
Dim $aDateTemp
Dim $aRuntimeTemp
Dim $aBackupJobs_byName[1] = [ 0 ]
Dim $aBackupJobs_byID[1] = [ 0 ]
Dim $aBackupJobs_Selection[1] = [ 0 ]

Dim $s_JSONOutput
Dim $sRunCommand
Dim $sJobStatus
Dim $iJobStatus
Dim $iJobhowlongago
Dim $iJobBytes
Dim $iJobRuntime
Dim $iJobPercentComplete
Dim $iJobErrorCode

; Für senden per Zabbix-Sender etc:
Global $sZabbix_agentd_exe
Global $sZabbix_agentd_conf
Global $sZabbix_sender_exe
Global $sZabbix_Hostname
Global $sZabbix_Server
Global $iZabbix_Server_Port
Global $sZabbix_String2Send
Global $s_JSONOutput
Global $bSendStatus = False

Global $iStartTime
Global $iRunTime

; Ok, we need the BEMCLI Extension for PowerShell, just find the BackupExec Installation Folder
; we take 3 try - depends of we are a 32 or 64 bit exe and if we run on a 32 or 64 bit system
Global $sWow64 = ""
;~ If @AutoItX64 = 1 Then
;~ 	$sWow64 = "\Wow6432Node"
;~ EndIf

$iStartTime = _DateDiff("s", "1970/01/01 00:00:00", _NowCalc())

For $i = 1 To 100000
	$stemp = RegEnumVal("HKEY_LOCAL_MACHINE64\SOFTWARE\Microsoft\Windows\CurrentVersion\Installer\Folders", $i)
;~     $stemp = RegEnumVal("HKEY_LOCAL_MACHINE\SOFTWARE" & $sWow64 & "\Microsoft\Windows\CurrentVersion\Installer\Folders", $i)
    If @error <> 0 Then
		ConsoleWrite("Exitloop with Error-Code: " & @error & @CRLF)
		ExitLoop
	EndIf
;~ 	ConsoleWrite("Searching \Modules\BEMCLI\ in: " & $stemp & @CRLF)
	;                       1234567890123456
	If StringRight($stemp, 16) = "\Modules\BEMCLI\" Then
		$bemcli = "Import-Module '" & $stemp & "BEMCLI'"
		ExitLoop
	EndIf
Next

If $bemcli = "" Then
	ConsoleWriteError("Error, no installed BackupExec PowerShell found" & @CRLF)
	Exit 1
EndIf

;~ ConsoleWrite("$bemcli = " & $bemcli & @CRLF)
;~ Exit 0

; ##########################################################################################################################
; ##########################################################################################################################
;                                                                                   ########################################
; ######## ##     ## ##    ##  ######  ######## ####  #######  ##    ##  ######     ########################################
; ##       ##     ## ###   ## ##    ##    ##     ##  ##     ## ###   ## ##    ##    ########################################
; ##       ##     ## ####  ## ##          ##     ##  ##     ## ####  ## ##          ########################################
; ######   ##     ## ## ## ## ##          ##     ##  ##     ## ## ## ##  ######     ########################################
; ##       ##     ## ##  #### ##          ##     ##  ##     ## ##  ####       ##    ########################################
; ##       ##     ## ##   ### ##    ##    ##     ##  ##     ## ##   ### ##    ##    ########################################
; ##        #######  ##    ##  ######     ##    ####  #######  ##    ##  ######     ########################################
;                                                                                   ########################################
; ##########################################################################################################################
; ##########################################################################################################################
Func _BEMCLI($sbemparameter)
	Local $sRunCommand
	Local $outputBEMCLI
	Local $errorsBEMCLI
	Local $hBEMCLI
	Local $iBEMCLImaxWaitTime = 20000
	Local $iBEMCLImaxWaitTimeSTART
	Local $stdoutReadFEHLER
	; build the Command for run
	$sRunCommand = $bemcli & " ; " & $sbemparameter
	; Start the timer for max wait time
	$iBEMCLImaxWaitTimeSTART = TimerInit()
	; run the Command
;~ 	ConsoleWrite('powershell.exe Set-ExecutionPolicy Bypass ; "' & $sRunCommand & '"' & @CRLF)
	$hBEMCLI = Run('powershell.exe Set-ExecutionPolicy Bypass ; "' & $sRunCommand & '"', @SystemDir, @SW_HIDE, $STDIN_CHILD + $STDOUT_CHILD + $STDERR_CHILD)
	StdinWrite($hBEMCLI, @CRLF)
	StdinWrite($hBEMCLI)
	;get the output
	Do
		;Sleep(5)
		; get the output
		$outputBEMCLI = $outputBEMCLI & StdoutRead($hBEMCLI)
		; get the errors
		$errorsBEMCLI = $errorsBEMCLI & StderrRead($hBEMCLI)
		; did we have an error while reading?
		$stdoutReadFEHLER = @error
		If $stdoutReadFEHLER <> "" Then
			; No error, go on
			If $outputBEMCLI = "" Then
				; but also no output, let us take a 2. try
				$outputBEMCLI = $outputBEMCLI & StdoutRead($hBEMCLI)
				If $outputBEMCLI = "" Then
					; anymore no output, oh oh
					If $stdoutReadFEHLER <> "" Then
						; but we have an error message
						Return $errorsBEMCLI
					EndIf
				EndIf
			EndIf
		EndIf
	Until $stdoutReadFEHLER Or TimerDiff($iBEMCLImaxWaitTimeSTART) > $iBEMCLImaxWaitTime
	;MsgBox(0,"",$outputBEMCLI)
	Return $outputBEMCLI
EndFunc ;<== End _BEMCLI()

; ###################################################################################
; _ANSI2OEM löst das Problem mit dem Umlauten und anderen Sonderzeichen. Es wandelt Text so um das er korrekt in der DOS-Box dargestellt wird
; So können hier im Quellcode auch Umlaute verwendet werden (in den Textausgaben) und diese werden dann korrekt dargestellt
; Wir zudem für die Prüfung der Gruppenzugehörigkeit benötigt für Gruppen mit Umlauten, z.B. Domänen-Admins
; Dank an Xenobiologist von AutoIt.de für diese Lösung: http://www.autoit.de/index.php?page=Thread&threadID=9461&highlight=ANSI2OEM

Func _ANSI2OEM($text)
	$text = DllCall('user32.dll', 'Int', 'CharToOem', 'str', $text, 'str', '')
	Return $text[2]
EndFunc   ;==>_ANSI2OEM

; ##################################################################################################################
;             ########    ###    ########  ########  #### ##     ##          ######   #######  ##    ## ########
;                  ##    ## ##   ##     ## ##     ##  ##   ##   ##          ##    ## ##     ## ###   ## ##
;                 ##    ##   ##  ##     ## ##     ##  ##    ## ##           ##       ##     ## ####  ## ##
;                ##    ##     ## ########  ########   ##     ###            ##       ##     ## ## ## ## ######
;               ##     ######### ##     ## ##     ##  ##    ## ##           ##       ##     ## ##  #### ##
;              ##      ##     ## ##     ## ##     ##  ##   ##   ##          ##    ## ##     ## ##   ### ##
;     ####### ######## ##     ## ########  ########  #### ##     ## #######  ######   #######  ##    ## ##
; ##################################################################################################################
Func _Zabbix_conf()
	Dim $sRegTMP
	Dim $iRegTMP = 0
	Dim $iLoop
	Dim $aRegTMP
	Dim $aZabbix_config
	Dim $sZabbix_config_file
	Dim $a2temp
	While 1
		$iRegTMP = $iRegTMP + 1
		$sRegTMP = RegEnumKey("HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\services", $iRegTMP)
		If @error Then
			ExitLoop
		EndIf
		$sRegTMP = RegRead("HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\services\" & $sRegTMP, "ImagePath")
		If @error = 0 Then
			If StringInStr($sRegTMP, "zabbix_agentd.exe") > 0 Then
				;ConsoleWrite("Gefunden: " & $sRegTMP & @CRLF)
				$aRegTMP = StringSplit($sRegTMP, '"')
				;_ArrayDisplay($aRegTMP)
				$sZabbix_agentd_exe = $aRegTMP[2]
				$sZabbix_sender_exe = StringReplace($sZabbix_agentd_exe, "zabbix_agentd.exe", "zabbix_sender.exe")
				$sZabbix_config_file = $aRegTMP[4]
				$sZabbix_agentd_conf = $sZabbix_config_file
				$aZabbix_config = FileReadToArray($sZabbix_config_file)
				If @error = 0 Then
					For $iLoop = 0 To (UBound($aZabbix_config) -1)
						If StringLeft($aZabbix_config[$iLoop], StringLen("ServerActive=")) = "ServerActive=" Then
							$sZabbix_Server = StringReplace($aZabbix_config[$iLoop], "ServerActive=", "")
							$sZabbix_Server = StringReplace($sZabbix_Server, " ", "")
							$a2temp = StringSplit($sZabbix_Server, ":")
							If $a2temp[0] = 1 Then
								$iZabbix_Server_Port = 10051
							Else
								$sZabbix_Server = $a2temp[1]
								$iZabbix_Server_Port = $a2temp[2]
							EndIf
						EndIf
						If StringLeft($aZabbix_config[$iLoop], StringLen("Hostname=")) = "Hostname=" Then
							$sZabbix_Hostname = StringReplace($aZabbix_config[$iLoop], "Hostname=", "")
							$sZabbix_Hostname = StringReplace($sZabbix_Hostname, " ", "")
						EndIf
					Next
				Else
					ConsoleWrite("File not found: " & $sZabbix_config_file & @CRLF)
					Exit 1
				EndIf
				If FileExists($sZabbix_sender_exe) = 0 Then
					ConsoleWrite("zabbix_sender.exe not found at: " & $sZabbix_sender_exe & @CRLF)
					Exit 1
				EndIf
			EndIf
		EndIf
	WEnd
;~ 	ConsoleWrite("zabbix_agentd.exe:       " & '"' & $sZabbix_agentd_exe & '"' & @CRLF)
;~ 	ConsoleWrite("zabbix_sender.exe:       " & '"' & $sZabbix_sender_exe & '"' & @CRLF)
;~ 	ConsoleWrite("Hostname used in Zabbix: " & '"' & $sZabbix_Hostname & '"' &  @CRLF)
;~ 	ConsoleWrite("IP(:Port) Zabbix Server: " & '"' & $sZabbix_Server & '"' & @CRLF)
EndFunc

; ###################################################################################################################################################################################################################
;              ######  ######## ##    ## ########        ##  ######   #######  ##    ##  #######  ########    ###    ########  ########  #### ##     ##  ######  ######## ########  ##     ## ######## ########
;             ##    ## ##       ###   ## ##     ##       ## ##    ## ##     ## ###   ## ##     ##      ##    ## ##   ##     ## ##     ##  ##   ##   ##  ##    ## ##       ##     ## ##     ## ##       ##     ##
;             ##       ##       ####  ## ##     ##       ## ##       ##     ## ####  ##        ##     ##    ##   ##  ##     ## ##     ##  ##    ## ##   ##       ##       ##     ## ##     ## ##       ##     ##
;              ######  ######   ## ## ## ##     ##       ##  ######  ##     ## ## ## ##  #######     ##    ##     ## ########  ########   ##     ###     ######  ######   ########  ##     ## ######   ########
;                   ## ##       ##  #### ##     ## ##    ##       ## ##     ## ##  #### ##          ##     ######### ##     ## ##     ##  ##    ## ##         ## ##       ##   ##    ##   ##  ##       ##   ##
;             ##    ## ##       ##   ### ##     ## ##    ## ##    ## ##     ## ##   ### ##         ##      ##     ## ##     ## ##     ##  ##   ##   ##  ##    ## ##       ##    ##    ## ##   ##       ##    ##
;     #######  ######  ######## ##    ## ########   ######   ######   #######  ##    ## ######### ######## ##     ## ########  ########  #### ##     ##  ######  ######## ##     ##    ###    ######## ##     ##
; ###################################################################################################################################################################################################################
Func _SendJSON2ZabbixServer()
	Local $ConnectedSocket, $iTCPBytesSend
	; Delete the last ,
	$sZabbix_String2Send = StringTrimRight($sZabbix_String2Send, StringLen("," & "@CRLF")) & '@CRLF'
	; finalize the String for a perfect JSON
	$sZabbix_String2Send = $sZabbix_String2Send & ']}' & '@CRLF'
	$sZabbix_String2Send = StringReplace($sZabbix_String2Send, '@CRLF', @CRLF)
	ConsoleWrite(@CRLF)
	ConsoleWrite("Complete JSON-String for sending:" & "---------------------------------" & @CRLF)
	ConsoleWrite($sZabbix_String2Send & @CRLF & @CRLF)
	ConsoleWrite("Using Zabbix_Agentd.conf File : " & $sZabbix_agentd_conf & @CRLF)
	ConsoleWrite("Zabbix Server                 : " & $sZabbix_Server & @CRLF)
	ConsoleWrite("Zabbix Server Port            : " & $iZabbix_Server_Port & @CRLF & @CRLF)
	ConsoleWrite("Number of bytes are being sent to the server : " & StringLen($sZabbix_String2Send) & @CRLF)
	TCPStartup()
	$ConnectedSocket = -1
	ConsoleWrite("Connecting Server ... ")
	$ConnectedSocket = TCPConnect($sZabbix_Server, $iZabbix_Server_Port)
	If @error Then
		ConsoleWrite("ERROR: " & @error & @CRLF)
	Else
		ConsoleWrite("done" & @CRLF)
	EndIf
	; "{""request"":""agent data"",""data"":[{""host"":""Servername"",""key"":""log"",""value"" :""hallo!!!""}]}"
	ConsoleWrite("Sending Data ... ")
	$iTCPBytesSend = TCPSend($ConnectedSocket, StringToBinary($sZabbix_String2Send, 4))
	$stemp = TCPRecv($ConnectedSocket, 1024)
	If @error Then
		ConsoleWrite("ERROR: " & @error & @CRLF)
	Else
		ConsoleWrite("done" & @CRLF)
	EndIf
	ConsoleWrite("Response from the Server: " & BinaryToString($stemp) & @CRLF & @CRLF)
	ConsoleWrite(@CRLF)
	ConsoleWrite("Number of bytes have been successfully sent  : " & $iTCPBytesSend & @CRLF)
	ConsoleWrite("Disconnect Server ... ")
	TCPCloseSocket($ConnectedSocket)
	If @error Then
		ConsoleWrite("ERROR: " & @error & @CRLF)
	Else
		ConsoleWrite("done" & @CRLF & "--------------------------------------------------------------" & @CRLF & @CRLF)
	EndIf
	TCPShutdown()
EndFunc

; #############################################################################################################################################################################################################################################################
;              ######  ######## ##    ## ########  ######## #### ##       ########         ##      ## #### ######## ##     ##         ########    ###    ########  ########  #### ##     ##          ######  ######## ##    ## ########  ######## ########
;             ##    ## ##       ###   ## ##     ## ##        ##  ##       ##               ##  ##  ##  ##     ##    ##     ##              ##    ## ##   ##     ## ##     ##  ##   ##   ##          ##    ## ##       ###   ## ##     ## ##       ##     ##
;             ##       ##       ####  ## ##     ## ##        ##  ##       ##               ##  ##  ##  ##     ##    ##     ##             ##    ##   ##  ##     ## ##     ##  ##    ## ##           ##       ##       ####  ## ##     ## ##       ##     ##
;              ######  ######   ## ## ## ##     ## ######    ##  ##       ######           ##  ##  ##  ##     ##    #########            ##    ##     ## ########  ########   ##     ###             ######  ######   ## ## ## ##     ## ######   ########
;                   ## ##       ##  #### ##     ## ##        ##  ##       ##               ##  ##  ##  ##     ##    ##     ##           ##     ######### ##     ## ##     ##  ##    ## ##                 ## ##       ##  #### ##     ## ##       ##   ##
;             ##    ## ##       ##   ### ##     ## ##        ##  ##       ##               ##  ##  ##  ##     ##    ##     ##          ##      ##     ## ##     ## ##     ##  ##   ##   ##          ##    ## ##       ##   ### ##     ## ##       ##    ##
;     #######  ######  ######## ##    ## ########  ##       #### ######## ######## #######  ###  ###  ####    ##    ##     ## ####### ######## ##     ## ########  ########  #### ##     ## #######  ######  ######## ##    ## ########  ######## ##     ##
; #############################################################################################################################################################################################################################################################
Func _SendFile_with_Zabbix_Sender($sFileForZabbixSender)
	FileDelete($sFileForZabbixSender)
	FileWriteLine($sFileForZabbixSender, $s_JSONOutput)
;~ 	ConsoleWrite(@CRLF)
;~ 	ConsoleWrite("Complete JSON-String for sending:" & "---------------------------------" & @CRLF)
;~ 	ConsoleWrite($s_JSONOutput & @CRLF & @CRLF)
;~ 	ConsoleWrite("Using Zabbix_Sender.exe       : " & $sZabbix_sender_exe & @CRLF)
;~ 	ConsoleWrite("Using Zabbix_Agentd.conf File : " & $sZabbix_agentd_conf & @CRLF)
;~ 	ConsoleWrite("Using Temp-Directory          : " & @TempDir & @CRLF)
;~ 	ConsoleWrite("File to Send :                : " & $sFileForZabbixSender & @CRLF)
;~ 	ConsoleWrite("Hostname in Zabbix            : " & $sZabbix_Hostname & @CRLF)
;~ 	ConsoleWrite("Zabbix Server                 : " & $sZabbix_Server & @CRLF)
;~ 	ConsoleWrite("Zabbix Server Port            : " & $iZabbix_Server_Port & @CRLF)
;~ 	ConsoleWrite("Complete Run-Command          : " & '"' & $sZabbix_sender_exe & '"' & " -c " & '"' & $sZabbix_agentd_conf & '"' & " -i " & '"' & $sFileForZabbixSender & '"' & @CRLF)
;~ 	ConsoleWrite("Output from Zabbix_Sender.exe : " & @CRLF)
;~ 	ConsoleWrite("-------------------------------" & @CRLF)
	RunWait('"' & $sZabbix_sender_exe & '"' & " -c " & '"' & $sZabbix_agentd_conf & '"' & " -i " & '"' & $sFileForZabbixSender & '"', "", @SW_HIDE,  $STDOUT_CHILD)
	;Sleep(1000)
;~ 	ConsoleWrite(@CRLF)
EndFunc

; #############################################################################################################################################################################################################################################################################
;              ######  ######## ##    ## ########  ##     ##    ###    ##       ##     ## ########         ##      ## #### ######## ##     ##         ########    ###    ########  ########  #### ##     ##          ######  ######## ##    ## ########  ######## ########
;             ##    ## ##       ###   ## ##     ## ##     ##   ## ##   ##       ##     ## ##               ##  ##  ##  ##     ##    ##     ##              ##    ## ##   ##     ## ##     ##  ##   ##   ##          ##    ## ##       ###   ## ##     ## ##       ##     ##
;             ##       ##       ####  ## ##     ## ##     ##  ##   ##  ##       ##     ## ##               ##  ##  ##  ##     ##    ##     ##             ##    ##   ##  ##     ## ##     ##  ##    ## ##           ##       ##       ####  ## ##     ## ##       ##     ##
;              ######  ######   ## ## ## ##     ## ##     ## ##     ## ##       ##     ## ######           ##  ##  ##  ##     ##    #########            ##    ##     ## ########  ########   ##     ###             ######  ######   ## ## ## ##     ## ######   ########
;                   ## ##       ##  #### ##     ##  ##   ##  ######### ##       ##     ## ##               ##  ##  ##  ##     ##    ##     ##           ##     ######### ##     ## ##     ##  ##    ## ##                 ## ##       ##  #### ##     ## ##       ##   ##
;             ##    ## ##       ##   ### ##     ##   ## ##   ##     ## ##       ##     ## ##               ##  ##  ##  ##     ##    ##     ##          ##      ##     ## ##     ## ##     ##  ##   ##   ##          ##    ## ##       ##   ### ##     ## ##       ##    ##
;     #######  ######  ######## ##    ## ########     ###    ##     ## ########  #######  ######## #######  ###  ###  ####    ##    ##     ## ####### ######## ##     ## ########  ########  #### ##     ## #######  ######  ######## ##    ## ########  ######## ##     ##
; #############################################################################################################################################################################################################################################################################

Func _SendValue_with_Zabbix_Sender($sItemName, $sItemValue)
		; ConsoleWrite('"' & $sZabbix_sender_exe & '"' & " -c " & '"' & $sZabbix_agentd_conf & '"' & " -k " & '"' & $sItemName & '" -o "' & $sItemValue & '"' & @CRLF)
		RunWait('"' & $sZabbix_sender_exe & '"' & " -z " & '"' & $sZabbix_Server & '" -s "' & $sZabbix_Hostname & '"' & " -k " & '"' & $sItemName & '" -o "' & $sItemValue & '"', "", @SW_HIDE, $STDOUT_CHILD)
EndFunc


; ##########################################################################################################################
; ##########################################################################################################################
;                                       ####################################################################################
; ##     ##    ###    #### ##    ##     ####################################################################################
; ###   ###   ## ##    ##  ###   ##     ####################################################################################
; #### ####  ##   ##   ##  ####  ##     ####################################################################################
; ## ### ## ##     ##  ##  ## ## ##     ####################################################################################
; ##     ## #########  ##  ##  ####     ####################################################################################
; ##     ## ##     ##  ##  ##   ###     ####################################################################################
; ##     ## ##     ## #### ##    ##     ####################################################################################
;                                       ####################################################################################
; ##########################################################################################################################
; ##########################################################################################################################

If StringInStr($CmdLineRaw, "discoverjobs") > 0 Then
	Dim $s_JSONOutput
	; Get all scheduled and active Jobs
	$stemp = _BEMCLI($aparameter[0])

	$atemp = StringSplit($stemp, @CRLF)

	For $i = 1 To $atemp[0]
		If StringLeft($atemp[$i],StringLen("Id")) = "Id" Then
			$aatemp = StringSplit($atemp[$i],' : ', 1)
			_ArrayAdd($aBackupJobs_byID, $aatemp[$aatemp[0]])
			$aBackupJobs_byID[0] = $aBackupJobs_byID[0] + 1
		EndIf
		If StringLeft($atemp[$i],StringLen("Name")) = "Name" Then
			$aatemp = StringSplit($atemp[$i],' : ', 1)
			_ArrayAdd($aBackupJobs_byName, $aatemp[$aatemp[0]])
			$aBackupJobs_byName[0] = $aBackupJobs_byName[0] + 1
		EndIf
		If StringLeft($atemp[$i],StringLen("SelectionSummary")) = "SelectionSummary" Then
			$aatemp = StringSplit($atemp[$i],' : ', 1)
			_ArrayAdd($aBackupJobs_Selection, $aatemp[$aatemp[0]])
			$aBackupJobs_Selection[0] = $aBackupJobs_Selection[0] + 1
		EndIf
	Next
	$s_JSONOutput = '- znil.BackupExecPS[trapperdiscoverjobs] {"data":['
;~ 	$s_JSONOutput = '{"data":['
	For $i = 1 To $aBackupJobs_byName[0]
		$atemp = StringSplit($aBackupJobs_byName[$i],"")
		$stemp = ""
		For $j = 1 To $atemp[0]
			Switch Asc($atemp[$j])
				Case 132
					$atemp[$j] = "ae"
				Case 148
					$atemp[$j] = "oe"
				Case 129
					$atemp[$j] = "ue"
				Case 225
					$atemp[$j] = "ss"
				Case Else
					;nichts
			EndSwitch
			$stemp = $stemp & $atemp[$j]
		Next
		$aBackupJobs_byName[$i] = $stemp
;~ 		$s_JSONOutput = $s_JSONOutput & @CRLF
;~ 		$s_JSONOutput = $s_JSONOutput & "     " & '{' & @CRLF
;~ 		$s_JSONOutput = $s_JSONOutput & "          " & '"{#BACKUPEXECJOB}":"' & $aBackupJobs_byName[$i] & '",' & @CRLF
;~ 		$s_JSONOutput = $s_JSONOutput & "          " & '"{#BACKUPEXECID}":"' & $aBackupJobs_byID[$i] & '",' & @CRLF
;~ 		;$s_JSONOutput = $s_JSONOutput & "          " & '"{#BACKUPEXECSELECTION}":"' & $aBackupJobs_Selection[$i] & '"' & @CRLF
;~ 		$s_JSONOutput = $s_JSONOutput & "          " & '"{#BACKUPEXECSELECTION}":"' & "---" & '"' & @CRLF
;~ 		$s_JSONOutput = $s_JSONOutput & "     " & '},'
		$s_JSONOutput = $s_JSONOutput & '{'
		$s_JSONOutput = $s_JSONOutput & '"{#BACKUPEXECJOB}":"' & $aBackupJobs_byName[$i] & '",'
		$s_JSONOutput = $s_JSONOutput & '"{#BACKUPEXECID}":"' & $aBackupJobs_byID[$i] & '",'
		$s_JSONOutput = $s_JSONOutput & '"{#BACKUPEXECSELECTION}":"' & "---" & '"'
		$s_JSONOutput = $s_JSONOutput & '},'

	Next
	$s_JSONOutput = StringTrimRight($s_JSONOutput, 1) & ']}'

;~ 	ConsoleWrite(_ANSI2OEM($s_JSONOutput) & @CRLF)
	_Zabbix_conf()
	_SendFile_with_Zabbix_Sender(@TempDir & "\Zabbix-BackupExec-Jobs.txt")
	$iRunTime = _DateDiff("s", "1970/01/01 00:00:00", _NowCalc()) - $iStartTime
	ConsoleWrite($iRunTime & @CRLF)
	Exit 0
EndIf

If $CmdLine[0] = 2 Then

	If $CmdLine[1] = "doit" Then
		_Zabbix_conf()
		$stemp = _BEMCLI(StringReplace($aparameter[3], '{ID of Job}',$CmdLine[2]))
		$atemp = StringSplit($stemp, @CRLF)
		For $i = 1 To $atemp[0]
			If StringLeft($atemp[$i],StringLen("JobStatus")) = "JobStatus" Then
				$aatemp = StringSplit($atemp[$i],' : ',1)
				$sJobStatus = $aatemp[$aatemp[0]]
;~ 				ConsoleWrite($sJobStatus & @CRLF)
				_SendValue_with_Zabbix_Sender("znil.BackupExecPS[jobstatus," & $CmdLine[2] & "]", $sJobStatus)
			EndIf

			If StringLeft($atemp[$i],StringLen("StartTime")) = "StartTime" Then
				$aatemp = StringSplit($atemp[$i],' : ',1)
				$stemp = $aatemp[$aatemp[0]]
				$aDateTemp = StringSplit($stemp, " .")
				; [1] = Tag
				; [2] = Monat
				; [3] = Jahr
				; [4] = Uhrzeit als hh:mm:ss
				$iJobhowlongago = _DateDiff("s", $aDateTemp[3] & "/" & $aDateTemp[2] & "/" & $aDateTemp[1] & " " & $aDateTemp[4], @YEAR & "/" & @MON & "/" & @MDAY & " " & @HOUR & ":" & @MIN & ":" & @SEC)
;~ 				ConsoleWrite($iJobhowlongago & @CRLF)
				_SendValue_with_Zabbix_Sender("znil.BackupExecPS[jobhowlongago," & $CmdLine[2] & "]", $iJobhowlongago)
			EndIf

			If StringLeft($atemp[$i],StringLen("TotalDataSizeBytes")) = "TotalDataSizeBytes" Then
				$aatemp = StringSplit($atemp[$i],' : ',1)
				$stemp = $aatemp[$aatemp[0]]
				$iJobBytes = Int($stemp)
;~ 				ConsoleWrite($iJobBytes & @CRLF)
				_SendValue_with_Zabbix_Sender("znil.BackupExecPS[jobbytes," & $CmdLine[2] & "]", $iJobBytes)
			EndIf

			If StringLeft($atemp[$i],StringLen("ElapsedTime")) = "ElapsedTime" Then
				$aatemp = StringSplit($atemp[$i],' : ',1)
				$stemp = $aatemp[$aatemp[0]]
				$aRuntimeTemp = StringSplit($stemp,":")
				; [1] = Stunden
				; [2] = Minuten
				; [3] = Sekunden
				$iJobRuntime = Int($aRuntimeTemp[3]) + (Int($aRuntimeTemp[2]) * 60) + (Int($aRuntimeTemp[1]) * 3600)
;~ 				ConsoleWrite($iJobRuntime & @CRLF)
				_SendValue_with_Zabbix_Sender("znil.BackupExecPS[jobruntime," & $CmdLine[2] & "]", $iJobRuntime)
			EndIf

			If StringLeft($atemp[$i],StringLen("PercentComplete")) = "PercentComplete" Then
				$aatemp = StringSplit($atemp[$i],' : ',1)
				$iJobPercentComplete = $aatemp[$aatemp[0]]
				If $iJobPercentComplete = -1 Then
					$iJobPercentComplete = 0
				EndIf
;~ 				ConsoleWrite($iJobPercentComplete & @CRLF)
				_SendValue_with_Zabbix_Sender("znil.BackupExecPS[jobPercentComplete," & $CmdLine[2] & "]", $iJobPercentComplete)
			EndIf

			If StringLeft($atemp[$i],StringLen("ErrorCode")) = "ErrorCode" Then
				$aatemp = StringSplit($atemp[$i],' : ',1)
				$iJobErrorCode = $aatemp[$aatemp[0]]
;~ 				ConsoleWrite($iJobErrorCode & @CRLF)
				_SendValue_with_Zabbix_Sender("znil.BackupExecPS[jobErrorCode," & $CmdLine[2] & "]", $iJobErrorCode)
			EndIf

			If StringLeft($atemp[$i],StringLen("ErrorCategory")) = "ErrorCategory" Then
				$aatemp = StringSplit($atemp[$i],' : ',1)
				$iJobErrorCode = $aatemp[$aatemp[0]]
;~ 				ConsoleWrite($iJobErrorCode & @CRLF)
				_SendValue_with_Zabbix_Sender("znil.BackupExecPS[jobErrorCategory," & $CmdLine[2] & "]", $iJobErrorCode)
			EndIf

			If StringInStr($atemp[$i], "Get-BEJob : Cannot find") > 0 Then
				ConsoleWrite("ZBX_NOTSUPPORTED" & @CRLF)
				Exit 0
			EndIf
		Next
		$iRunTime = _DateDiff("s", "1970/01/01 00:00:00", _NowCalc()) - $iStartTime
		ConsoleWrite($iRunTime & @CRLF)
		Exit 0
	EndIf

; #########################################################################################################################################################################

	If $CmdLine[1] = "jobstatus" Then
		$stemp = _BEMCLI(StringReplace($aparameter[3], '{ID of Job}',$CmdLine[2]))
		$atemp = StringSplit($stemp, @CRLF)
		For $i = 1 To $atemp[0]
			If StringLeft($atemp[$i],StringLen("JobStatus")) = "JobStatus" Then
				$aatemp = StringSplit($atemp[$i],' : ',1)
				$sJobStatus = $aatemp[$aatemp[0]]
				ConsoleWrite($sJobStatus & @CRLF)
				Exit 0
			EndIf

			If StringInStr($atemp[$i], "Get-BEJob : Cannot find") > 0 Then
				ConsoleWrite("ZBX_NOTSUPPORTED" & @CRLF)
				Exit 0
			EndIf
		Next
	EndIf

	If $CmdLine[1] = "jobhowlongago" Then
		$stemp = _BEMCLI(StringReplace($aparameter[3], '{ID of Job}',$CmdLine[2]))
		$atemp = StringSplit($stemp, @CRLF)
		For $i = 1 To $atemp[0]
			If StringLeft($atemp[$i],StringLen("StartTime")) = "StartTime" Then
				$aatemp = StringSplit($atemp[$i],' : ',1)
				$stemp = $aatemp[$aatemp[0]]
				$aDateTemp = StringSplit($stemp, " .")
				; [1] = Tag
				; [2] = Monat
				; [3] = Jahr
				; [4] = Uhrzeit als hh:mm:ss
				$iJobhowlongago = _DateDiff("s", $aDateTemp[3] & "/" & $aDateTemp[2] & "/" & $aDateTemp[1] & " " & $aDateTemp[4], @YEAR & "/" & @MON & "/" & @MDAY & " " & @HOUR & ":" & @MIN & ":" & @SEC)
				ConsoleWrite($iJobhowlongago & @CRLF)
				Exit 0
			EndIf
			If StringInStr($atemp[$i], "Get-BEJob : Cannot find") > 0 Then
				ConsoleWrite("ZBX_NOTSUPPORTED" & @CRLF)
				Exit 0
			EndIf
		Next
	EndIf

	If $CmdLine[1] = "jobbytes" Then
		$stemp = _BEMCLI(StringReplace($aparameter[3], '{ID of Job}',$CmdLine[2]))
		$atemp = StringSplit($stemp, @CRLF)
		For $i = 1 To $atemp[0]
			If StringLeft($atemp[$i],StringLen("TotalDataSizeBytes")) = "TotalDataSizeBytes" Then
				$aatemp = StringSplit($atemp[$i],' : ',1)
				$stemp = $aatemp[$aatemp[0]]
				$iJobBytes = Int($stemp)
				ConsoleWrite($iJobBytes & @CRLF)
				Exit 0
			EndIf
			If StringInStr($atemp[$i], "Get-BEJob : Cannot find") > 0 Then
				ConsoleWrite("ZBX_NOTSUPPORTED" & @CRLF)
				Exit 0
			EndIf
		Next
	EndIf

	If $CmdLine[1] = "jobruntime" Then
		$stemp = _BEMCLI(StringReplace($aparameter[3], '{ID of Job}',$CmdLine[2]))
		$atemp = StringSplit($stemp, @CRLF)
		For $i = 1 To $atemp[0]
			If StringLeft($atemp[$i],StringLen("ElapsedTime")) = "ElapsedTime" Then
				$aatemp = StringSplit($atemp[$i],' : ',1)
				$stemp = $aatemp[$aatemp[0]]
				$aRuntimeTemp = StringSplit($stemp,":")
				; [1] = Stunden
				; [2] = Minuten
				; [3] = Sekunden
				$iJobRuntime = Int($aRuntimeTemp[3]) + (Int($aRuntimeTemp[2]) * 60) + (Int($aRuntimeTemp[1]) * 3600)
				ConsoleWrite($iJobRuntime & @CRLF)
				Exit 0
			EndIf
			If StringInStr($atemp[$i], "Get-BEJob : Cannot find") > 0 Then
				ConsoleWrite("ZBX_NOTSUPPORTED" & @CRLF)
				Exit 0
			EndIf
		Next
	EndIf

	If $CmdLine[1] = "jobPercentComplete" Then
		$stemp = _BEMCLI(StringReplace($aparameter[3], '{ID of Job}',$CmdLine[2]))
		$atemp = StringSplit($stemp, @CRLF)
		For $i = 1 To $atemp[0]
			If StringLeft($atemp[$i],StringLen("PercentComplete")) = "PercentComplete" Then
				$aatemp = StringSplit($atemp[$i],' : ',1)
				$iJobPercentComplete = $aatemp[$aatemp[0]]
				If $iJobPercentComplete = -1 Then
					$iJobPercentComplete = 0
				EndIf
				ConsoleWrite($iJobPercentComplete & @CRLF)
				Exit 0
			EndIf
			If StringInStr($atemp[$i], "Get-BEJob : Cannot find") > 0 Then
				ConsoleWrite("ZBX_NOTSUPPORTED" & @CRLF)
				Exit 0
			EndIf
		Next
	EndIf

	If $CmdLine[1] = "jobErrorCode" Then
		$stemp = _BEMCLI(StringReplace($aparameter[3], '{ID of Job}',$CmdLine[2]))
		$atemp = StringSplit($stemp, @CRLF)
		For $i = 1 To $atemp[0]
			If StringLeft($atemp[$i],StringLen("ErrorCode")) = "ErrorCode" Then
				$aatemp = StringSplit($atemp[$i],' : ',1)
				$iJobErrorCode = $aatemp[$aatemp[0]]
				ConsoleWrite($iJobErrorCode & @CRLF)
				Exit 0
			EndIf
			If StringInStr($atemp[$i], "Get-BEJob : Cannot find") > 0 Then
				ConsoleWrite("ZBX_NOTSUPPORTED" & @CRLF)
				Exit 0
			EndIf
		Next
	EndIf

	If $CmdLine[1] = "jobErrorCategory" Then
		$stemp = _BEMCLI(StringReplace($aparameter[3], '{ID of Job}',$CmdLine[2]))
		$atemp = StringSplit($stemp, @CRLF)
		For $i = 1 To $atemp[0]
			If StringLeft($atemp[$i],StringLen("ErrorCategory")) = "ErrorCategory" Then
				$aatemp = StringSplit($atemp[$i],' : ',1)
				$iJobErrorCode = $aatemp[$aatemp[0]]
				ConsoleWrite($iJobErrorCode & @CRLF)
				Exit 0
			EndIf
			If StringInStr($atemp[$i], "Get-BEJob : Cannot find") > 0 Then
				ConsoleWrite("ZBX_NOTSUPPORTED" & @CRLF)
				Exit 0
			EndIf
		Next
	EndIf

EndIf

Exit 0