<?php
/**
* Skin file for skin znilwikiskin
*
*/

require_once( dirname( __FILE__ ) . '/../MonoBook.php' );

/**
 * SkinTemplate class for znilwikiskin
 * @ingroup Skins
 */
class Skinznilwikiskin extends SkinMonoBook {

	var $skinname = 'znilwikiskin', $stylename = 'znilwikiskin',
		$template = 'znilwikiskinTemplate', $useHeadElement = true;
	/**
	 * @param $out OutputPage object
	 */
	function setupSkinUserCss( OutputPage $out ){
		parent::setupSkinUserCss( $out );
		$out->addModuleStyles( "skins.znilwikiskin" );
	}
}




?>
<?php
class znilwikiskinTemplate extends MonoBookTemplate {
	/** ############################################################################################################################ **/
/** 06.05.2012 gendert Bernhard Linz ########################################################################################## **/
	function searchBox() {
		global $wgUseTwoButtonsSearchForm;
?>
	<div id="p-search" class="portletSidebar">
	<TABLE id="QuickbarHeader" WIDTH="100%">
			<TR> 
				<TD><?php $this->msg('search') ?></TD>
			</TR> 
		</TABLE>
		<!-- <h5><label for="searchInput"><?php $this->msg('search') ?></label></h5> -->
		<div id="searchBody" class="QuickBarBody">
			<form action="<?php $this->text('wgScript') ?>" id="searchform">
				<input type='hidden' name="title" value="<?php $this->text('searchtitle') ?>"/>
				<?php echo $this->makeSearchInput(array( "id" => "searchInput" )); ?>

				<?php echo $this->makeSearchButton("go", array( "id" => "searchGoButton", "class" => "searchButton" ));
				if ($wgUseTwoButtonsSearchForm): ?>&#160;
				<?php echo $this->makeSearchButton("fulltext", array( "id" => "mw-searchButton", "class" => "searchButton" ));
				else: ?>

				<div><a href="<?php $this->text('searchaction') ?>" rel="search"><?php $this->msg('powersearch-legend') ?></a></div><?php
				endif; ?>

			</form>
		</div>
	</div>
<?php
	}

	/** ############################################################################################################################ **/
/** 06.05.2012 gendert Bernhard Linz ########################################################################################## **/
	function toolbox() {
?>
	<div class="portletSidebar" id="p-tb">
		<TABLE id="QuickbarHeader" WIDTH="100%">
			<TR> 
				<TD><?php $this->msg('toolbox') ?></TD>
			</TR> 
		</TABLE>
		<!-- <h5><?php $this->msg('toolbox') ?></h5> -->
		<div class="QuickBarBody">
			<ul>
<?php
		foreach ( $this->getToolbox() as $key => $tbitem ) { ?>
				<?php echo $this->makeListItem($key, $tbitem); ?>

<?php
		}
		wfRunHooks( 'MonoBookTemplateToolboxEnd', array( &$this ) );
		wfRunHooks( 'SkinTemplateToolboxEnd', array( &$this, true ) );
?>
			</ul>
		</div>
	</div>
<?php
	}

	/** ############################################################################################################################ **/
/** 06.05.2012 gendert Bernhard Linz ########################################################################################## **/
	function customBox( $bar, $cont ) {
		$portletAttribs = array( 'class' => 'generated-sidebar portlet', 'id' => Sanitizer::escapeId( "p-$bar" ) );
		$tooltip = Linker::titleAttrib( "p-$bar" );
		if ( $tooltip !== false ) {
			$portletAttribs['title'] = $tooltip;
		}
		echo '	' . Html::openElement( 'div', $portletAttribs );
?>
		<TABLE id="QuickbarHeader" WIDTH="100%">
			<TR> 
				<TD><?php $out = wfMsg( $bar ); if (wfEmptyMsg($bar, $out)) echo htmlspecialchars($bar); else echo htmlspecialchars($out); ?></TD>
				<!--<TD><h5><?php $out = wfMsg( $bar ); if (wfEmptyMsg($bar, $out)) echo htmlspecialchars($bar); else echo htmlspecialchars($out); ?></h5></TD>-->
			</TR> 
		</TABLE>
		<!-- <h5><?php $msg = wfMessage( $bar ); echo htmlspecialchars( $msg->exists() ? $msg->text() : $bar ); ?></h5> -->
		<div class='QuickBarBody'>
<?php   if ( is_array( $cont ) ) { ?>
			<ul>
<?php 			foreach($cont as $key => $val) { ?>
				<?php echo $this->makeListItem($key, $val); ?>

<?php			} ?>
			</ul>
<?php   } else {
			# allow raw HTML block to be defined by extensions
			print $cont;
		}
?>
		</div>
	</div>
<?php
	}
} // end of class
?>
