#NoTrayIcon
#Region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_Icon=Icon256-32.ico
#AutoIt3Wrapper_UseX64=n
#AutoIt3Wrapper_Change2CUI=y
#AutoIt3Wrapper_Res_Description=Zabbix Eventlog Monitor with Filter http://znil.net
#AutoIt3Wrapper_Res_Fileversion=1.0.0.80
#AutoIt3Wrapper_Res_Fileversion_AutoIncrement=y
#AutoIt3Wrapper_Res_LegalCopyright=2015 Bernhard Linz
#AutoIt3Wrapper_Res_SaveSource=y
#AutoIt3Wrapper_Res_Language=1031
#AutoIt3Wrapper_Res_Field=Website|http://znil.net
#AutoIt3Wrapper_Res_Field=Manual|http://znil.net/index.php?title=Zabbix:Template_Zabbix_Eventlog
#AutoIt3Wrapper_Res_Field=See You|znil.net
#EndRegion ;**** Directives created by AutoIt3Wrapper_GUI ****
Opt('MustDeclareVars', 1)
#Region    ;************ Includes ************
#Include <Array.au3>
#include <Constants.au3>
#include <Date.au3>
#include <EventLog.au3>
#Include <WinAPIEx.au3>
#EndRegion ;************ Includes ************

; #########################################################################################
;     ##     ##    ###    ########  ####    ###    ########  ##       ########  ######
;     ##     ##   ## ##   ##     ##  ##    ## ##   ##     ## ##       ##       ##    ##
;     ##     ##  ##   ##  ##     ##  ##   ##   ##  ##     ## ##       ##       ##
;     ##     ## ##     ## ########   ##  ##     ## ########  ##       ######    ######
;      ##   ##  ######### ##   ##    ##  ######### ##     ## ##       ##             ##
;       ## ##   ##     ## ##    ##   ##  ##     ## ##     ## ##       ##       ##    ##
;        ###    ##     ## ##     ## #### ##     ## ########  ######## ########  ######
; #########################################################################################

Global $oMyError
Global $objWMIService

$oMyError = ObjEvent("AutoIt.Error", "oMyError") ; Install a custom error handler
$objWMIService = ObjGet("winmgmts:{impersonationLevel = impersonate}!\\localhost\root\cimv2")

Global $sHELP = "Zabbix_Eventlog.exe [OPTION] [Period] [Blacklist-File]" & @CRLF & _
				@CRLF & _
				"Possible Values for OPTIONS:" & @CRLF & _
				"----------------------------" & @CRLF & _
				"discovereventlogs  : Create JSON String for detected Eventlogs" & @CRLF & _
				"                     Output Text to Console and send JSON direct to" & @CRLF & _
				"                     Zabbix Server (using Configuration of Zabbix Service" & @CRLF & _
				"                     ZBX_NOTSUPPORTED if there any errors" & @CRLF & _
				'[Name of Eventlog] : For Example "Application" or "System"' & @CRLF & _
				@CRLF & _
				"Other optional Parameters:" & @CRLF & _
				"--------------------------" & @CRLF & _
				"Period             : How many Seconds go back in Eventlog from now." & @CRLF & _
				"                     Default: 600 Seconds, min. Value 60 Seconds" & @CRLF & _
				@CRLF & _
				"Blacklist-File     : Additional Textfile with Blacklistet Eventlog Entries" & @CRLF & _
				"					  The first 13 Lines of File will be ignored!" & @CRLF & _
				'                     Take a look at Example File "Zabbix_Eventlog-Filter.txt"' & @CRLF & _
				"                     This File will used in addition to the local" & @CRLF & _
				'                     "Zabbix_Eventlog-Filter.txt" File in the same Directory as the' & @CRLF & _
				'                     "Zabbix_Eventlog.exe"' & _
				@CRLF & _
				'First 13 Lines of a "Zabbix_Eventlog-Filter.txt":' & @CRLF & _
				"-------------------------------------------------" & @CRLF & _
				'01: Create one Line for every Eventlog-Entry to filter.' & @CRLF & _
				'02: Examples:' & @CRLF & _
				'03: ---------' & @CRLF & _
				'04: Filter all Eventlog-Entries with the EventID 999 (Excat match!)' & @CRLF & _
				'05: EventID:999' & @CRLF & _
				'06: Filter all Eventlog-Entries with the Text "TESTAPP" at SOURCE (String in String Compare, case insensitive!)' & @CRLF & _
				'07: Source:TESTAPP' & @CRLF & _
				'08: Filter all Eventlog-Entries with the Text "Channel restart failed" at Message (String in String Compare, case insensitive!)' & @CRLF & _
				'09: Message:Channel restart failed' & @CRLF & _
				'10: Filter all Eventlog-Entries with the Text "{0006F03A-0000-0000-C000-000000000046}" at Insertion (String in String Compare, case insensitive!)' & @CRLF & _
				'11: Insertion:{0006F03A-0000-0000-C000-000000000046}' & @CRLF & _
				'12: DO NOT REMOVE THE FIRST 13 LINES! - The first 13 Lines will be ignored by Zabbix_Eventlog.exe (Hardcoded!) !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!' & @CRLF & _
				'13: ################################################################################################################################################' & @CRLF & _
				@CRLF





;ConsoleWrite(_GetEventsWMI($CmdLine[1]))

Global $sZabbix_agentd_exe
Global $sZabbix_agentd_conf
Global $sZabbix_sender_exe
Global $sZabbix_Hostname
Global $sZabbix_Server
Global $iZabbix_Server_Port

Global $aEventlogs[1][9]	; [0][0] = Anzahl
							; [x][1] = Name des Eventlogs (LogfileName)
							; [x][2] = Maximale Gre (MaxFileSize)
							; [x][3] = Aktuelle Gre (FileSize)
							; [x][4] = Anzahl der Eintrge (NumberOfRecords)
							; [x][5] = Status (Status)
							; [x][6] = Pfad zum DisplayNameFile
							; [x][7] = DisplayNameID
							; [x][8] = DisplayName
$aEventlogs[0][1] = "LogfileName"
$aEventlogs[0][2] = "MaxFileSize"
$aEventlogs[0][3] = "FileSize"
$aEventlogs[0][4] = "NumberOfRecords"
$aEventlogs[0][5] = "Status"
$aEventlogs[0][6] = "DisplayNameFile"
$aEventlogs[0][7] = "DisplayNameID"
$aEventlogs[0][8] = "DisplayName"

; Fr unbekannte Eventlogs. Name steht dafr in verschiedenen DLL-Dateien, hat sich als zu umstndlich erwiesen diesen daraus aus zu lesen
Global $aDisplayNamesOfEventlogs[3][2]	; [0][x] = LogFileName
										; [1][x] = DisplayName
$aDisplayNamesOfEventlogs[0][0] = "HardwareEvents"
$aDisplayNamesOfEventlogs[0][1]	= "Hardware Events"
$aDisplayNamesOfEventlogs[1][0] = "ODiag"
$aDisplayNamesOfEventlogs[1][1] = "Microsoft Office Diagnostics"
$aDisplayNamesOfEventlogs[2][0] = "OSession"
$aDisplayNamesOfEventlogs[2][1] = "Microsoft Office Sessions"

Global $aMessage[1][8]	; [0][0] = Anzahl
						; [x][1] = EventID
						; [x][2] = Time-String
						; [x][3] = Source
						; [x][4] = Insertion
						; [x][5] = Message
						; [x][6] = EventType (1 = Error, 2 = Warning, 3 = Information, 4 = Security Audit Success, 5 = Security Audit Failure)$aMessage[0][0] = 0
$aMessage[0][1] = "EventID"
$aMessage[0][2] = "Time"
$aMessage[0][3] = "Source"
$aMessage[0][4] = "Insertion"
$aMessage[0][5] = "Message"
$aMessage[0][6] = "EventType"

Global $iStartTime
Global $iRunTime

Global $b_QueryEventlog
Global $i_Period = 600

Global $s_JSONOutput
Global $colItems = ""

Global $aFilterList_EventID[1]
Global $aFilterList_Source[1]
Global $aFilterList_Message[1]
Global $aFilterList_Insertion[1]
$aFilterList_EventID[0] = 0
$aFilterList_Source[0] = 0
$aFilterList_Message[0] = 0
$aFilterList_Insertion[0] = 0
Global $bFilterEntry

Global $sLokalFilterFile = @ScriptDir & "\Zabbix_Eventlog-Filter.txt"
Global $sRemoteFilterFile

Global $iEventCounter = 0
Global $iERROR_Counter = 0
Global $iWARNING_Counter = 0
Global $iFiltered_Counter = 0

Global $bError_was_send = False
Global $bWarning_was_send = False


Dim $stemp
; ##################################################################################################################################################################################################################################################
; ##################################################################################################################################################################################################################################################
;                                                                                   ################################################################################################################################################################
; ######## ##     ## ##    ##  ######  ######## ####  #######  ##    ##  ######     ################################################################################################################################################################
; ##       ##     ## ###   ## ##    ##    ##     ##  ##     ## ###   ## ##    ##    ################################################################################################################################################################
; ##       ##     ## ####  ## ##          ##     ##  ##     ## ####  ## ##          ################################################################################################################################################################
; ######   ##     ## ## ## ## ##          ##     ##  ##     ## ## ## ##  ######     ################################################################################################################################################################
; ##       ##     ## ##  #### ##          ##     ##  ##     ## ##  ####       ##    ################################################################################################################################################################
; ##       ##     ## ##   ### ##    ##    ##     ##  ##     ## ##   ### ##    ##    ################################################################################################################################################################
; ##        #######  ##    ##  ######     ##    ####  #######  ##    ##  ######     ################################################################################################################################################################
;                                                                                   ################################################################################################################################################################
; ##################################################################################################################################################################################################################################################
; ##################################################################################################################################################################################################################################################

; ###################################################################################
; _ANSI2OEM lst das Problem mit dem Umlauten und anderen Sonderzeichen. Es wandelt Text so um das er korrekt in der DOS-Box dargestellt wird
; So knnen hier im Quellcode auch Umlaute verwendet werden (in den Textausgaben) und diese werden dann korrekt dargestellt
; Wir zudem fr die Prfung der Gruppenzugehrigkeit bentigt fr Gruppen mit Umlauten, z.B. Domnen-Admins
; Dank an Xenobiologist von AutoIt.de fr diese Lsung: http://www.autoit.de/index.php?page=Thread&threadID=9461&highlight=ANSI2OEM
Func _ANSI2OEM($text)
	$text = DllCall('user32.dll', 'Int', 'CharToOem', 'str', $text, 'str', '')
	Return $text[2]
EndFunc   ;==>_ANSI2OEM
; #######################################################################################################################################################
;             ########  ########    ###    ########  #### ##    ## ######## #### ##       ######## ######## ########  ######## #### ##       ########
;             ##     ## ##         ## ##   ##     ##  ##  ###   ## ##        ##  ##          ##    ##       ##     ## ##        ##  ##       ##
;             ##     ## ##        ##   ##  ##     ##  ##  ####  ## ##        ##  ##          ##    ##       ##     ## ##        ##  ##       ##
;             ########  ######   ##     ## ##     ##  ##  ## ## ## ######    ##  ##          ##    ######   ########  ######    ##  ##       ######
;             ##   ##   ##       ######### ##     ##  ##  ##  #### ##        ##  ##          ##    ##       ##   ##   ##        ##  ##       ##
;             ##    ##  ##       ##     ## ##     ##  ##  ##   ### ##        ##  ##          ##    ##       ##    ##  ##        ##  ##       ##
;     ####### ##     ## ######## ##     ## ########  #### ##    ## ##       #### ########    ##    ######## ##     ## ##       #### ######## ########
; #######################################################################################################################################################
Func _ReadInFilterFile($s_FilterFile)
	Local $atemp
	Local $sValue
	; Check if File exist
	If FileExists($s_FilterFile) = 0 Then
		Return
	EndIf
	$atemp = FileReadToArray($s_FilterFile)
	; Check Reading File
	If IsArray($atemp) = 0 Then
		Return
	EndIf
	; We Skip the first 13 Lines so the array must be greater than 13
	If UBound($atemp) < 14 Then
		Return
	EndIf
	; All Checks finished, Process the Filters
	;_ArrayDisplay($atemp)
	; $aFilterList_EventID[0] = 0
	; $aFilterList_Source[0] = 0
	; $aFilterList_Message[0] = 0
	; $aFilterList_Insertion[0] = 0
;~ 	ConsoleWrite("Ubound($atemp): " & UBound($atemp) & @CRLF)
	For $j = 13 To (UBound($atemp) - 1)
;~ 		ConsoleWrite("$j: " & $j & @CRLF)
		; EventID
		If StringLeft($atemp[$j], StringLen("EventID:")) = "EventID:" Then
;~ 			ConsoleWrite("EventID!" & @CRLF)
			$sValue = Int(StringTrimLeft($atemp[$j], StringLen("EventID:")))
			If IsNumber($sValue) = 1 Then
				$aFilterList_EventID[0] = $aFilterList_EventID[0] + 1
				ReDim $aFilterList_EventID[ $aFilterList_EventID[0] + 1 ]
				$aFilterList_EventID[ $aFilterList_EventID[0] ] = $sValue
			EndIf
		EndIf
		If StringLeft($atemp[$j], StringLen("Source:")) = "Source:" Then
;~ 			ConsoleWrite("Source!" & @CRLF)
			$sValue = StringTrimLeft($atemp[$j], StringLen("Source:"))
			If StringLen($sValue) > 0 Then
				$aFilterList_Source[0] = $aFilterList_Source[0] + 1
				ReDim $aFilterList_Source[ $aFilterList_Source[0] + 1 ]
				$aFilterList_Source[ $aFilterList_Source[0] ] = $sValue
			EndIf
		EndIf
		If StringLeft($atemp[$j], StringLen("Message:")) = "Message:" Then
;~ 			ConsoleWrite("Message!" & @CRLF)
			$sValue = StringTrimLeft($atemp[$j], StringLen("Message:"))
			If StringLen($sValue) > 0 Then
				$aFilterList_Message[0] = $aFilterList_Message[0] + 1
				ReDim $aFilterList_Message[ $aFilterList_Message[0] + 1 ]
				$aFilterList_Message[ $aFilterList_Message[0] ] = $sValue
			EndIf
		EndIf
		If StringLeft($atemp[$j], StringLen("Insertion:")) = "Insertion:" Then
;~ 			ConsoleWrite("Insertion!" & @CRLF)
			$sValue = StringTrimLeft($atemp[$j], StringLen("Insertion:"))
			If StringLen($sValue) > 0 Then
				$aFilterList_Insertion[0] = $aFilterList_Insertion[0] + 1
				ReDim $aFilterList_Insertion[ $aFilterList_Insertion[0] + 1 ]
				$aFilterList_Insertion[ $aFilterList_Insertion[0] ] = $sValue
			EndIf
		EndIf
	Next
;~ 	_ArrayDisplay($aFilterList_EventID)
;~ 	_ArrayDisplay($aFilterList_Source)
;~ 	_ArrayDisplay($aFilterList_Message)
;~ 	_ArrayDisplay($aFilterList_Insertion)
EndFunc
; ###########################################################################################################################################################
;              ######   ######## ########    ###    ##       ##       ######## ##     ## ######## ##    ## ######## ##        #######   ######    ######
;             ##    ##  ##          ##      ## ##   ##       ##       ##       ##     ## ##       ###   ##    ##    ##       ##     ## ##    ##  ##    ##
;             ##        ##          ##     ##   ##  ##       ##       ##       ##     ## ##       ####  ##    ##    ##       ##     ## ##        ##
;             ##   #### ######      ##    ##     ## ##       ##       ######   ##     ## ######   ## ## ##    ##    ##       ##     ## ##   ####  ######
;             ##    ##  ##          ##    ######### ##       ##       ##        ##   ##  ##       ##  ####    ##    ##       ##     ## ##    ##        ##
;             ##    ##  ##          ##    ##     ## ##       ##       ##         ## ##   ##       ##   ###    ##    ##       ##     ## ##    ##  ##    ##
;     #######  ######   ########    ##    ##     ## ######## ######## ########    ###    ######## ##    ##    ##    ########  #######   ######    ######
; ###########################################################################################################################################################
Func _GetAllEventlogs()
	$colItems = $objWMIService.ExecQuery("SELECT * FROM Win32_NTEventlogFile", "WQL", 0x10 + 0x20)
	If IsObj($colItems) then
		For $objItem In $colItems
			If $objItem.NumberOfRecords > 0 Then
				$aEventlogs[0][0] = $aEventlogs[0][0] + 1
				ReDim $aEventlogs[ $aEventlogs[0][0] + 1 ][9]
				$aEventlogs[ $aEventlogs[0][0] ][1] = $objItem.LogfileName
				$aEventlogs[ $aEventlogs[0][0] ][2] = $objItem.MaxFileSize
				$aEventlogs[ $aEventlogs[0][0] ][3] = $objItem.FileSize
				$aEventlogs[ $aEventlogs[0][0] ][4] = $objItem.NumberOfRecords
				$aEventlogs[ $aEventlogs[0][0] ][5] = $objItem.Status
				$aEventlogs[ $aEventlogs[0][0] ][6] = RegRead("HKLM\SYSTEM\CurrentControlSet\services\eventlog\" & $objItem.LogfileName, "DisplayNameFile")
				$aEventlogs[ $aEventlogs[0][0] ][7] = RegRead("HKLM\SYSTEM\CurrentControlSet\services\eventlog\" & $objItem.LogfileName, "DisplayNameID")
			EndIf
		Next
	EndIf
EndFunc

; ##################################################################################################################
;             ########    ###    ########  ########  #### ##     ##          ######   #######  ##    ## ########
;                  ##    ## ##   ##     ## ##     ##  ##   ##   ##          ##    ## ##     ## ###   ## ##
;                 ##    ##   ##  ##     ## ##     ##  ##    ## ##           ##       ##     ## ####  ## ##
;                ##    ##     ## ########  ########   ##     ###            ##       ##     ## ## ## ## ######
;               ##     ######### ##     ## ##     ##  ##    ## ##           ##       ##     ## ##  #### ##
;              ##      ##     ## ##     ## ##     ##  ##   ##   ##          ##    ## ##     ## ##   ### ##
;     ####### ######## ##     ## ########  ########  #### ##     ## #######  ######   #######  ##    ## ##
; ##################################################################################################################
Func _Zabbix_conf()
	Local $sRegTMP
	Local $iRegTMP = 0
	Local $iLoop
	Local $aRegTMP
	Local $aZabbix_config
	Local $sZabbix_config_file
	Local $a2temp
	While 1
		$iRegTMP = $iRegTMP + 1
		$sRegTMP = RegEnumKey("HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\services", $iRegTMP)
		If @error Then
			ExitLoop
		EndIf
		$sRegTMP = RegRead("HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\services\" & $sRegTMP, "ImagePath")
		If @error = 0 Then
			If StringInStr($sRegTMP, "zabbix_agentd.exe") > 0 Then
				;ConsoleWrite("Gefunden: " & $sRegTMP & @CRLF)
				$aRegTMP = StringSplit($sRegTMP, '"')
				;_ArrayDisplay($aRegTMP)
				$sZabbix_agentd_exe = $aRegTMP[2]
				$sZabbix_sender_exe = StringReplace($sZabbix_agentd_exe, "zabbix_agentd.exe", "zabbix_sender.exe")
				$sZabbix_config_file = $aRegTMP[4]
				$sZabbix_agentd_conf = $sZabbix_config_file
				$aZabbix_config = FileReadToArray($sZabbix_config_file)
				If @error = 0 Then
					For $iLoop = 0 To (UBound($aZabbix_config) -1)
						If StringLeft($aZabbix_config[$iLoop], StringLen("ServerActive=")) = "ServerActive=" Then
							$sZabbix_Server = StringReplace($aZabbix_config[$iLoop], "ServerActive=", "")
							$sZabbix_Server = StringReplace($sZabbix_Server, " ", "")
							$a2temp = StringSplit($sZabbix_Server, ":")
							If $a2temp[0] = 1 Then
								$iZabbix_Server_Port = 10051
							Else
								$sZabbix_Server = $a2temp[1]
								$iZabbix_Server_Port = $a2temp[2]
							EndIf
						EndIf
						If StringLeft($aZabbix_config[$iLoop], StringLen("Hostname=")) = "Hostname=" Then
							$sZabbix_Hostname = StringReplace($aZabbix_config[$iLoop], "Hostname=", "")
							$sZabbix_Hostname = StringReplace($sZabbix_Hostname, " ", "")
						EndIf
					Next
				Else
					ConsoleWrite("File not found: " & $sZabbix_config_file & @CRLF)
					Exit 1
				EndIf
				If FileExists($sZabbix_sender_exe) = 0 Then
					ConsoleWrite("zabbix_sender.exe not found at: " & $sZabbix_sender_exe & @CRLF)
					Exit 1
				EndIf
			EndIf
		EndIf
	WEnd
;~ 	ConsoleWrite("zabbix_agentd.exe:       " & '"' & $sZabbix_agentd_exe & '"' & @CRLF)
;~ 	ConsoleWrite("zabbix_sender.exe:       " & '"' & $sZabbix_sender_exe & '"' & @CRLF)
;~ 	ConsoleWrite("Hostname used in Zabbix: " & '"' & $sZabbix_Hostname & '"' &  @CRLF)
;~ 	ConsoleWrite("IP(:Port) Zabbix Server: " & '"' & $sZabbix_Server & '"' & @CRLF)
EndFunc

; #############################################################################################################################################################################################################################################################
;              ######  ######## ##    ## ########  ######## #### ##       ########         ##      ## #### ######## ##     ##         ########    ###    ########  ########  #### ##     ##          ######  ######## ##    ## ########  ######## ########
;             ##    ## ##       ###   ## ##     ## ##        ##  ##       ##               ##  ##  ##  ##     ##    ##     ##              ##    ## ##   ##     ## ##     ##  ##   ##   ##          ##    ## ##       ###   ## ##     ## ##       ##     ##
;             ##       ##       ####  ## ##     ## ##        ##  ##       ##               ##  ##  ##  ##     ##    ##     ##             ##    ##   ##  ##     ## ##     ##  ##    ## ##           ##       ##       ####  ## ##     ## ##       ##     ##
;              ######  ######   ## ## ## ##     ## ######    ##  ##       ######           ##  ##  ##  ##     ##    #########            ##    ##     ## ########  ########   ##     ###             ######  ######   ## ## ## ##     ## ######   ########
;                   ## ##       ##  #### ##     ## ##        ##  ##       ##               ##  ##  ##  ##     ##    ##     ##           ##     ######### ##     ## ##     ##  ##    ## ##                 ## ##       ##  #### ##     ## ##       ##   ##
;             ##    ## ##       ##   ### ##     ## ##        ##  ##       ##               ##  ##  ##  ##     ##    ##     ##          ##      ##     ## ##     ## ##     ##  ##   ##   ##          ##    ## ##       ##   ### ##     ## ##       ##    ##
;     #######  ######  ######## ##    ## ########  ##       #### ######## ######## #######  ###  ###  ####    ##    ##     ## ####### ######## ##     ## ########  ########  #### ##     ## #######  ######  ######## ##    ## ########  ######## ##     ##
; #############################################################################################################################################################################################################################################################
Func _SendFile_with_Zabbix_Sender($sFileForZabbixSender)
	FileDelete($sFileForZabbixSender)
	FileWriteLine($sFileForZabbixSender, $s_JSONOutput)
;~ 	ConsoleWrite(@CRLF)
;~ 	ConsoleWrite("Complete JSON-String for sending:" & "---------------------------------" & @CRLF)
;~ 	ConsoleWrite($s_JSONOutput & @CRLF & @CRLF)
;~ 	ConsoleWrite("Using Zabbix_Sender.exe       : " & $sZabbix_sender_exe & @CRLF)
;~ 	ConsoleWrite("Using Zabbix_Agentd.conf File : " & $sZabbix_agentd_conf & @CRLF)
;~ 	ConsoleWrite("Using Temp-Directory          : " & @TempDir & @CRLF)
;~ 	ConsoleWrite("File to Send :                : " & $sFileForZabbixSender & @CRLF)
;~ 	ConsoleWrite("Hostname in Zabbix            : " & $sZabbix_Hostname & @CRLF)
;~ 	ConsoleWrite("Zabbix Server                 : " & $sZabbix_Server & @CRLF)
;~ 	ConsoleWrite("Zabbix Server Port            : " & $iZabbix_Server_Port & @CRLF)
;~ 	ConsoleWrite("Complete Run-Command          : " & '"' & $sZabbix_sender_exe & '"' & " -c " & '"' & $sZabbix_agentd_conf & '"' & " -i " & '"' & $sFileForZabbixSender & '"' & @CRLF)
;~ 	ConsoleWrite("Output from Zabbix_Sender.exe : " & @CRLF)
;~ 	ConsoleWrite("-------------------------------" & @CRLF)
;~ 	RunWait('"' & $sZabbix_sender_exe & '"' & " -c " & '"' & $sZabbix_agentd_conf & '"' & " -i " & '"' & $sFileForZabbixSender & '"', "", @SW_HIDE)
	RunWait('"' & $sZabbix_sender_exe & '"' & " -c " & '"' & $sZabbix_agentd_conf & '"' & " -i " & '"' & $sFileForZabbixSender & '"', "", @SW_HIDE, $RUN_CREATE_NEW_CONSOLE)
	;Sleep(1000)
;~ 	ConsoleWrite(@CRLF)
EndFunc

; #############################################################################################################################################################################################################################################################################
;              ######  ######## ##    ## ########  ##     ##    ###    ##       ##     ## ########         ##      ## #### ######## ##     ##         ########    ###    ########  ########  #### ##     ##          ######  ######## ##    ## ########  ######## ########
;             ##    ## ##       ###   ## ##     ## ##     ##   ## ##   ##       ##     ## ##               ##  ##  ##  ##     ##    ##     ##              ##    ## ##   ##     ## ##     ##  ##   ##   ##          ##    ## ##       ###   ## ##     ## ##       ##     ##
;             ##       ##       ####  ## ##     ## ##     ##  ##   ##  ##       ##     ## ##               ##  ##  ##  ##     ##    ##     ##             ##    ##   ##  ##     ## ##     ##  ##    ## ##           ##       ##       ####  ## ##     ## ##       ##     ##
;              ######  ######   ## ## ## ##     ## ##     ## ##     ## ##       ##     ## ######           ##  ##  ##  ##     ##    #########            ##    ##     ## ########  ########   ##     ###             ######  ######   ## ## ## ##     ## ######   ########
;                   ## ##       ##  #### ##     ##  ##   ##  ######### ##       ##     ## ##               ##  ##  ##  ##     ##    ##     ##           ##     ######### ##     ## ##     ##  ##    ## ##                 ## ##       ##  #### ##     ## ##       ##   ##
;             ##    ## ##       ##   ### ##     ##   ## ##   ##     ## ##       ##     ## ##               ##  ##  ##  ##     ##    ##     ##          ##      ##     ## ##     ## ##     ##  ##   ##   ##          ##    ## ##       ##   ### ##     ## ##       ##    ##
;     #######  ######  ######## ##    ## ########     ###    ##     ## ########  #######  ######## #######  ###  ###  ####    ##    ##     ## ####### ######## ##     ## ########  ########  #### ##     ## #######  ######  ######## ##    ## ########  ######## ##     ##
; #############################################################################################################################################################################################################################################################################

Func _SendValue_with_Zabbix_Sender($sItemName, $sItemValue)
		;ConsoleWrite('"' & $sZabbix_sender_exe & '"' & " -c " & '"' & $sZabbix_agentd_conf & '"' & " -k " & '"' & $sItemName & '" -o "' & $sItemValue & '"' & @CRLF)
		;RunWait('"' & $sZabbix_sender_exe & '"' & " -c " & '"' & $sZabbix_agentd_conf & '"' & " -k " & '"' & $sItemName & '" -o "' & $sItemValue & '"', "", @SW_HIDE)
		RunWait('"' & $sZabbix_sender_exe & '"' & " -c " & '"' & $sZabbix_agentd_conf & '"' & " -k " & '"' & $sItemName & '" -o "' & $sItemValue & '"', "", @SW_HIDE, $RUN_CREATE_NEW_CONSOLE)
EndFunc

; ##################################################################################################################
;             ######  ######## ##    ## ########  ########  ##     ## ##    ## ######## #### ##     ## ########
;             ##    ## ##       ###   ## ##     ## ##     ## ##     ## ###   ##    ##     ##  ###   ### ##
;             ##       ##       ####  ## ##     ## ##     ## ##     ## ####  ##    ##     ##  #### #### ##
;              ######  ######   ## ## ## ##     ## ########  ##     ## ## ## ##    ##     ##  ## ### ## ######
;                   ## ##       ##  #### ##     ## ##   ##   ##     ## ##  ####    ##     ##  ##     ## ##
;             ##    ## ##       ##   ### ##     ## ##    ##  ##     ## ##   ###    ##     ##  ##     ## ##
;     #######  ######  ######## ##    ## ########  ##     ##  #######  ##    ##    ##    #### ##     ## ########
; ##################################################################################################################
Func _SendRuntime()
   $iRunTime = _DateDiff("s", "1970/01/01 00:00:00", _NowCalc()) - $iStartTime
   _SendValue_with_Zabbix_Sender("znil.ZabbixEventlog.Runtime", $iRunTime)
EndFunc

; ############################################################################################################################
;              ######   ######## ######## ######## ##     ## ######## ##    ## ########  ######  ##      ## ##     ## ####
;             ##    ##  ##          ##    ##       ##     ## ##       ###   ##    ##    ##    ## ##  ##  ## ###   ###  ##
;             ##        ##          ##    ##       ##     ## ##       ####  ##    ##    ##       ##  ##  ## #### ####  ##
;             ##   #### ######      ##    ######   ##     ## ######   ## ## ##    ##     ######  ##  ##  ## ## ### ##  ##
;             ##    ##  ##          ##    ##        ##   ##  ##       ##  ####    ##          ## ##  ##  ## ##     ##  ##
;             ##    ##  ##          ##    ##         ## ##   ##       ##   ###    ##    ##    ## ##  ##  ## ##     ##  ##
;     #######  ######   ########    ##    ########    ###    ######## ##    ##    ##     ######   ###  ###  ##     ## ####
; ############################################################################################################################
Func _GetEventsWMI($i_SecondsBack = 600, $s_onlyEventID = "", $s_Categorie = "Application")
	Local $Eventlog_Err, $Eventlog_Err_Logfile, $Eventlog_Err_EventType, $Eventlog_Err_EventID, $Eventlog_Err_TimeGenerated, $Eventlog_Err_SourceName, $Eventlog_Err_InsertionStrings, $Eventlog_Err_Message
	Local $date_threshold, $days_threshold, $date_threshold_WQL, $now, $x;, $tmp
	Local $colItems
	Local $atemp
	Local $UTCTime = _Date_Time_GetSystemTime()
	$now = _Date_Time_SystemTimeToDateTimeStr($UTCTime, 1)
;~ 	ConsoleWrite("Zeit Unterschied = " & _DateDiff("s", _NowCalc, $now) & @CRLF)
;~ 	ConsoleWrite('@@ Debug(' & @ScriptLineNumber & ') : $now = ' & $now & @CRLF & '>Error code: ' & @error & @CRLF) ;### Debug Console
	$date_threshold = _DateAdd('s', ($i_SecondsBack * (-1)), $now) ;get the date / time value fom past
;~ 	ConsoleWrite('@@ Debug(' & @ScriptLineNumber & ') : $date_threshold = ' & $date_threshold & @CRLF & '>Error code: ' & @error & @CRLF) ;### Debug Console
;~ 	ConsoleWrite("_Date_Time_GetSystemTime : " & _Date_Time_SystemTimeToDateTimeStr($UTCTime, 1) & @CRLF)
	;$date_threshold_WQL = StringLeft(StringReplace(StringReplace(StringReplace(_DateAdd('s', ($i_SecondsBack * (-1)), $now), ":", ""), "/", ""), " ", ""), 8) ;convert to WQL-Supported Date Formats
	$date_threshold_WQL = StringReplace(StringReplace(StringReplace(_DateAdd('s', ($i_SecondsBack * (-1)), $now), ":", ""), "/", ""), " ", "") & ".000000+000"
;~ 	ConsoleWrite('@@ Debug(' & @ScriptLineNumber & ') : $i_SecondsBack = ' & $i_SecondsBack & @CRLF & '>Error code: ' & @error & @CRLF) ;### Debug Console
;~ 	ConsoleWrite('@@ Debug(' & @ScriptLineNumber & ') : $date_threshold_WQL = ' & $date_threshold_WQL & @CRLF & '>Error code: ' & @error & @CRLF) ;### Debug Console
;~ 	ConsoleWrite('@@ Debug(' & @ScriptLineNumber & ') : $s_Categorie = ' & $s_Categorie & @CRLF & '>Error code: ' & @error & @CRLF) ;### Debug Console
;~ 	ConsoleWrite("$date_threshold_WQL : " & $date_threshold_WQL & @CRLF)
;~ 	$date_threshold_WQL = "20150304100000.000000+000"
;~ 	ConsoleWrite("$date_threshold_WQL : " & $date_threshold_WQL & @CRLF)
	If $s_onlyEventID = "" Then
		$colItems = $objWMIService.ExecQuery("SELECT Logfile, EventType, EventCode, TimeGenerated, SourceName, InsertionStrings, Message FROM Win32_NTLogEvent WHERE LogFile='" & $s_Categorie & "' AND TimeGenerated >= '" & $date_threshold_WQL & "' AND ( EventType=1 OR EventType=2 )", "WQL", 0x30)
		; $colItems = $objWMIService.ExecQuery("SELECT Logfile, EventType, EventCode, TimeGenerated, SourceName, InsertionStrings, Message FROM Win32_NTLogEvent WHERE LogFile='" & $s_Categorie & "' AND TimeGenerated >= '" & $date_threshold_WQL & "' AND EventType=1", "WQL", 0x30)
	Else
		$colItems = $objWMIService.ExecQuery("SELECT Logfile, EventType, EventCode, TimeGenerated, SourceName, InsertionStrings, Message FROM Win32_NTLogEvent WHERE EventCode = '" & $s_onlyEventID & "' And LogFile='" & $s_Categorie & "' AND TimeGenerated >= '" & $date_threshold_WQL & "' AND EventType=1", "WQL", 0x30)
	EndIf
	If IsObj($colItems) Then
		For $objItem In $colItems
			$Eventlog_Err_Logfile = $objItem.Logfile
			$Eventlog_Err_EventType = $objItem.EventType
			$Eventlog_Err_EventID = $objItem.EventCode ;$objItem.EventIdentifier
			$Eventlog_Err_TimeGenerated = WMIDateStringToDate2($objItem.TimeGenerated)
			$Eventlog_Err_SourceName = $objItem.SourceName
			$Eventlog_Err_InsertionStrings = ""
			For $x = 0 To UBound($objItem.InsertionStrings) - 1
				If Number($objItem.InsertionStrings($x)) = 0 And StringLeft($objItem.InsertionStrings($x), 2) <> "%%" And $objItem.InsertionStrings($x) <> "" And StringLen($objItem.InsertionStrings($x)) > 1 Then ;skip unneeded strings
					$Eventlog_Err_InsertionStrings &= StringStripWS(StringReplace(StringReplace($objItem.InsertionStrings($x), Chr(10), ""), Chr(13), ""), 7) & ", "
				EndIf
			Next
			$Eventlog_Err_InsertionStrings = StringTrimRight($Eventlog_Err_InsertionStrings, 2)
			$Eventlog_Err_Message = StringStripWS(StringReplace(StringReplace($objItem.Message, Chr(10), ""), Chr(13), ""), 7)
			$Eventlog_Err &= "Localhost" & ": " & $Eventlog_Err_Logfile & @CRLF & _
							"Type : " & $Eventlog_Err_EventType & @CRLF & _
							"EventID : " & $Eventlog_Err_EventID & @CRLF & _
							"Time : " & $Eventlog_Err_TimeGenerated & @CRLF & _
							"Source : " & $Eventlog_Err_SourceName & @CRLF & _
							"Insertion : " & $Eventlog_Err_InsertionStrings & @CRLF & _
							"Message : " & $Eventlog_Err_Message & @CRLF & _
							"--------------------------------------------------" & @CRLF
			; $aMessage[1][7]	; [0][0] = Anzahl
								; [x][1] = EventID
								; [x][2] = Time-String
								; [x][3] = Source
								; [x][4] = Insertion
								; [x][5] = Message
								; [x][6] = EventType (1 = Error, 2 = Warning, 3 = Information, 4 = Security Audit Success, 5 = Security Audit Failure)

			$aMessage[0][0] = $aMessage[0][0] + 1
			ReDim $aMessage[ $aMessage[0][0] + 1 ][8]
			$aMessage[ $aMessage[0][0] ][1] = Int($Eventlog_Err_EventID)
			$aMessage[ $aMessage[0][0] ][2] = $Eventlog_Err_TimeGenerated
			$aMessage[ $aMessage[0][0] ][3] = $Eventlog_Err_SourceName
			$aMessage[ $aMessage[0][0] ][4] = $Eventlog_Err_InsertionStrings
			$aMessage[ $aMessage[0][0] ][5] = $Eventlog_Err_Message
			$aMessage[ $aMessage[0][0] ][6] = $Eventlog_Err_EventType
		Next
		;Return $Eventlog_Err
	Else
		;Return SetError(2, 0, "Error!")
	EndIf
EndFunc

; ##############################################################################################################################################################################################
;     ##      ## ##     ## #### ########     ###    ######## ########  ######  ######## ########  #### ##    ##  ######   ########  #######  ########     ###    ######## ########  #######
;     ##  ##  ## ###   ###  ##  ##     ##   ## ##      ##    ##       ##    ##    ##    ##     ##  ##  ###   ## ##    ##     ##    ##     ## ##     ##   ## ##      ##    ##       ##     ##
;     ##  ##  ## #### ####  ##  ##     ##  ##   ##     ##    ##       ##          ##    ##     ##  ##  ####  ## ##           ##    ##     ## ##     ##  ##   ##     ##    ##              ##
;     ##  ##  ## ## ### ##  ##  ##     ## ##     ##    ##    ######    ######     ##    ########   ##  ## ## ## ##   ####    ##    ##     ## ##     ## ##     ##    ##    ######    #######
;     ##  ##  ## ##     ##  ##  ##     ## #########    ##    ##             ##    ##    ##   ##    ##  ##  #### ##    ##     ##    ##     ## ##     ## #########    ##    ##       ##
;     ##  ##  ## ##     ##  ##  ##     ## ##     ##    ##    ##       ##    ##    ##    ##    ##   ##  ##   ### ##    ##     ##    ##     ## ##     ## ##     ##    ##    ##       ##
;      ###  ###  ##     ## #### ########  ##     ##    ##    ########  ######     ##    ##     ## #### ##    ##  ######      ##     #######  ########  ##     ##    ##    ######## #########
; ##############################################################################################################################################################################################
Func WMIDateStringToDate2($dtmDate)
    Return (StringMid($dtmDate, 7, 2) & "." & StringMid($dtmDate, 5, 2) & "." & StringLeft($dtmDate, 4) & " " & _
            StringMid($dtmDate, 9, 2) & ":" & StringMid($dtmDate, 11, 2) & ":" & StringMid($dtmDate, 13, 2))
EndFunc   ;==>WMIDateStringToDate2

; #####################################################################################
;      #######  ##     ## ##    ## ######## ########  ########   #######  ########
;     ##     ## ###   ###  ##  ##  ##       ##     ## ##     ## ##     ## ##     ##
;     ##     ## #### ####   ####   ##       ##     ## ##     ## ##     ## ##     ##
;     ##     ## ## ### ##    ##    ######   ########  ########  ##     ## ########
;     ##     ## ##     ##    ##    ##       ##   ##   ##   ##   ##     ## ##   ##
;     ##     ## ##     ##    ##    ##       ##    ##  ##    ##  ##     ## ##    ##
;      #######  ##     ##    ##    ######## ##     ## ##     ##  #######  ##     ##
; #####################################################################################
Func oMyError()
;~   Msgbox(0,"AutoItCOM Test","We intercepted a COM Error !"      & @CRLF  & @CRLF & _
;~              "err.description is: "    & @TAB & $oMyError.Description    & @CRLF & _
;~              "err.windescription:"     & @TAB & $oMyError.WinDescription & @CRLF & _
;~              "err.number is: "         & @TAB & Hex($oMyError.Number, 8) & @CRLF & _
;~              "err.lastdllerror is: "   & @TAB & $oMyError.LastDllError   & @CRLF & _
;~              "err.scriptline is: "     & @TAB & $oMyError.Scriptline     & @CRLF & _
;~              "err.source is: "         & @TAB & $oMyError.Source         & @CRLF & _
;~              "err.helpfile is: "       & @TAB & $oMyError.Helpfile       & @CRLF & _
;~              "err.helpcontext is: "    & @TAB & $oMyError.HelpContext _
;~             , 20)
	ConsoleWrite("ZBX_NOTSUPPORTED" & @CRLF)
EndFunc

; ##################################################################################################################################################################################################################################################
; ##################################################################################################################################################################################################################################################
;                                       ############################################################################################################################################################################################################
; ##     ##    ###    #### ##    ##     ############################################################################################################################################################################################################
; ###   ###   ## ##    ##  ###   ##     ############################################################################################################################################################################################################
; #### ####  ##   ##   ##  ####  ##     ############################################################################################################################################################################################################
; ## ### ## ##     ##  ##  ## ## ##     ############################################################################################################################################################################################################
; ##     ## #########  ##  ##  ####     ############################################################################################################################################################################################################
; ##     ## ##     ##  ##  ##   ###     ############################################################################################################################################################################################################
; ##     ## ##     ## #### ##    ##     ############################################################################################################################################################################################################
;                                       ############################################################################################################################################################################################################
; ##################################################################################################################################################################################################################################################
; ##################################################################################################################################################################################################################################################
$iStartTime = _DateDiff("s", "1970/01/01 00:00:00", _NowCalc())


If $CmdLine[0] = 0 Then
	ConsoleWrite($sHELP & @CRLF)
	Exit 0
EndIf

_Zabbix_conf()
_GetAllEventlogs()

If $CmdLine[1] = "discovereventlogs" Then
	$s_JSONOutput = '- znil.ZabbixEventlog[discovereventlogs] {"data":['
	For $i = 1 To $aEventlogs[0][0]
		$s_JSONOutput = $s_JSONOutput & '{'
		$s_JSONOutput = $s_JSONOutput & '"{#EVENTLOGNAME}":"' & $aEventlogs[$i][1] & '",'
		$s_JSONOutput = $s_JSONOutput & '"{#EVENTLOGDUMMY}":"' & "---" & '"'
		$s_JSONOutput = $s_JSONOutput & '},'
	Next
	$s_JSONOutput = StringTrimRight($s_JSONOutput, 1) & ']}'
	_SendFile_with_Zabbix_Sender(@ScriptDir & "\Zabbix_Eventlog-LLD-Eventlogs.txt")
	ConsoleWrite("0" & @CRLF)
	Exit 0
EndIf

If $CmdLine[1] = "statisticseventlogs" Then
	For $i = 1 To $aEventlogs[0][0]
		; $aEventlogs
		; [0][0] = Anzahl
		; [x][1] = Name des Eventlogs (LogfileName)
		; [x][2] = Maximale Gre (MaxFileSize)
		; [x][3] = Aktuelle Gre (FileSize)
		; [x][4] = Anzahl der Eintrge (NumberOfRecords)
		; [x][5] = Status (Status)
		; [x][6] = Pfad zum DisplayNameFile
		; [x][7] = DisplayNameID
		; [x][8] = DisplayName
		_SendValue_with_Zabbix_Sender("znil.ZabbixEventlog.MaxFileSize[" 		& $aEventlogs[$i][1] & "]", $aEventlogs[$i][2])
		_SendValue_with_Zabbix_Sender("znil.ZabbixEventlog.FileSize[" 			& $aEventlogs[$i][1] & "]", $aEventlogs[$i][3])
		_SendValue_with_Zabbix_Sender("znil.ZabbixEventlog.NumberOfRecords[" 	& $aEventlogs[$i][1] & "]", $aEventlogs[$i][4])
		_SendValue_with_Zabbix_Sender("znil.ZabbixEventlog.Status[" 			& $aEventlogs[$i][1] & "]", $aEventlogs[$i][5])
	Next
	_SendRuntime()
	ConsoleWrite("0" & @CRLF)
	Exit 0
EndIf

$b_QueryEventlog = False

For $i = 1 To $aEventlogs[0][0]
	If $CmdLine[1] = $aEventlogs[$i][1] Then
		$b_QueryEventlog = True
	EndIf
Next

If $b_QueryEventlog = False Then
	ConsoleWrite("ZBX_NOTSUPPORTED" & @CRLF)
	Exit 0
EndIf

; Check if we have a period as 2. Parameter
If $CmdLine[0] > 1 Then
	$i_Period = Int($CmdLine[2])
	If $i_Period < 60 Then
		$i_Period = 60
	EndIf
EndIf

_ReadInFilterFile($sLokalFilterFile)
; Check if we have an additional Filter File as 3. Parameter
If $CmdLine[0] > 2 Then
	$sRemoteFilterFile = $CmdLine[3]
	_ReadInFilterFile($sRemoteFilterFile)
EndIf

; $aMessage[1][8]	; [0][0] = Anzahl
					; [x][1] = EventID
					; [x][2] = Time-String
					; [x][3] = Source
					; [x][4] = Insertion
					; [x][5] = Message
					; [x][6] = EventType (1 = Error, 2 = Warning, 3 = Information, 4 = Security Audit Success, 5 = Security Audit Failure)$aMessage[0][0] = 0

_GetEventsWMI($i_Period, "", $CmdLine[1])

;~ If $aMessage[0][0] > 0 Then
;~ 	For $i = 1 To $aMessage[0][0]
;~ 		If (Int($aMessage[$i][6]) = 1) Or (Int($aMessage[$i][6]) = 2) Then
;~ 			If Int($aMessage[$i][6]) = 1 Then
;~ 				$stemp      = "EventType : ERROR" & @CRLF
;~ 			Else
;~ 				$stemp      = "EventType : WARNING" & @CRLF
;~ 			EndIf
;~ 			$stemp = $stemp & "EventID   : " & $aMessage[$i][1] & @CRLF
;~ 			$stemp = $stemp & "Source    : " & $aMessage[$i][3] & @CRLF
;~ 			$stemp = $stemp & "UTC Time  : " & $aMessage[$i][2] & @CRLF
;~ 			$stemp = $stemp & "Insertion : " & $aMessage[$i][4] & @CRLF
;~ 			$stemp = $stemp & "Message   : " & $aMessage[$i][5] & @CRLF & @CRLF
;~ 			ConsoleWrite($stemp)
;~ 		EndIf
;~ 		;$stemp = StringReplace($stemp, @CRLF, "\n")
;~ 		_SendValue_with_Zabbix_Sender("znil.ZabbixEventlog.Message[" & $CmdLine[1] & "," & Int($aMessage[$i][6]) & "]", $stemp)
;~ 	Next
;~ EndIf

;~ ConsoleWrite("##############################################################################################################################################" & @CRLF)

If $aMessage[0][0] > 0 Then
	For $i = 1 To $aMessage[0][0]
		If (Int($aMessage[$i][6]) = 1) Or (Int($aMessage[$i][6]) = 2) Then
			$bFilterEntry = False
			; $aFilterList_EventID[0]
			For $j = 1 To $aFilterList_EventID[0]
				If $aMessage[$i][1] = $aFilterList_EventID[$j] Then
					$bFilterEntry = True
;~ 					ConsoleWrite("EventID: " & $aMessage[$i][1] & " = " & $aFilterList_EventID[$j] & @CRLF)
				EndIf
			Next
			; $aFilterList_Source[0] = 0
			For $j = 1 To $aFilterList_Source[0]
				If StringInStr($aMessage[$i][3], $aFilterList_Source[$j]) > 0 Then
					$bFilterEntry = True
;~ 					ConsoleWrite("Source: '" & $aFilterList_Source[$j] & "' is in '" & $aMessage[$i][3] & "'" & @CRLF)
				EndIf
			Next
			; $aFilterList_Message[0] = 0
			For $j = 1 To $aFilterList_Message[0]
				If StringInStr($aMessage[$i][5], $aFilterList_Message[$j]) > 0 Then
					$bFilterEntry = True
;~ 					ConsoleWrite("Message: '" & $aFilterList_Message[$j] & "' is in '" & $aMessage[$i][5] & "'" & @CRLF)
				EndIf
			Next
			; $aFilterList_Insertion[0] = 0
			For $j = 1 To $aFilterList_Insertion[0]
				If StringInStr($aMessage[$i][4], $aFilterList_Insertion[$j]) > 0 Then
					$bFilterEntry = True
;~ 					ConsoleWrite("Insertion: '" & $aFilterList_Insertion[$j] & "' is in '" & $aMessage[$i][4] & "'" & @CRLF)
				EndIf
			Next
			If $bFilterEntry = False Then
				$iEventCounter = $iEventCounter + 1
				If Int($aMessage[$i][6]) = 1 Then
					$stemp      = @CRLF & @CRLF & "EventType : ERROR" & @CRLF
					$iERROR_Counter = $iERROR_Counter + 1
					$bError_was_send = True
				Else
					$stemp      = @CRLF & @CRLF & "EventType : WARNING" & @CRLF
					$iWARNING_Counter = $iWARNING_Counter + 1
					$bWarning_was_send = True
				EndIf
				$stemp = $stemp & "EventID   : " & $aMessage[$i][1] & @CRLF
				$stemp = $stemp & "Source    : " & $aMessage[$i][3] & @CRLF
				$stemp = $stemp & "UTC Time  : " & $aMessage[$i][2] & @CRLF
				$stemp = $stemp & "Insertion : " & StringLeft(StringReplace($aMessage[$i][4], '"', "'"),128) & @CRLF
				$stemp = $stemp & "Message   : " & @CRLF
				$stemp = $stemp & "----------- " & @CRLF
				$stemp = $stemp & StringReplace(StringReplace(StringReplace($aMessage[$i][5], Chr(9), " "), ". ", "." & @CRLF), '"', "'") & @CRLF & @CRLF
				$stemp = $stemp & "---------------------------------------------------------------------------------------------------" & @CRLF
				$stemp = $stemp & "This is Entry No. " & $i & " of " & $aMessage[0][0] & " Total Entries in the last " & $i_Period & " Seconds" & @CRLF
				$stemp = $stemp & "Check the Logs for additional Entries!!!!" & @CRLF
				;ConsoleWrite($stemp)
				_SendValue_with_Zabbix_Sender("znil.ZabbixEventlog.Message[" & $CmdLine[1] & "," & Int($aMessage[$i][6]) & "]", $stemp)
			Else
				$iFiltered_Counter = $iFiltered_Counter + 1
			EndIf
		EndIf
	Next
EndIf
; print Value of Events witch where send
_SendValue_with_Zabbix_Sender("znil.ZabbixEventlog.WarningsLastPeriod[" & $CmdLine[1] & "]", $iWARNING_Counter)
_SendValue_with_Zabbix_Sender("znil.ZabbixEventlog.ErrorsLastPeriod[" & $CmdLine[1] & "]", $iERROR_Counter)
_SendValue_with_Zabbix_Sender("znil.ZabbixEventlog.FilteredLastPeriod[" & $CmdLine[1] & "]", $iFiltered_Counter)
If $bError_was_send = False Then
	_SendValue_with_Zabbix_Sender("znil.ZabbixEventlog.Message[" & $CmdLine[1] & ",1]", "-=ZABBIX-EVENTLOG=- No Events for " & $i_Period & " Seconds")
EndIf
If $bWarning_was_send = False Then
	_SendValue_with_Zabbix_Sender("znil.ZabbixEventlog.Message[" & $CmdLine[1] & ",2]", "-=ZABBIX-EVENTLOG=- No Events for " & $i_Period & " Seconds")
EndIf
_SendRuntime()
ConsoleWrite($iEventCounter & @CRLF)

; ##################################################################################################################################################################################################################################################
; ##################################################################################################################################################################################################################################################
;                                          #########################################################################################################################################################################################################
; ######## ##    ## ########  ########     #########################################################################################################################################################################################################
; ##       ###   ## ##     ## ##           #########################################################################################################################################################################################################
; ##       ####  ## ##     ## ##           #########################################################################################################################################################################################################
; ######   ## ## ## ##     ## ######       #########################################################################################################################################################################################################
; ##       ##  #### ##     ## ##           #########################################################################################################################################################################################################
; ##       ##   ### ##     ## ##           #########################################################################################################################################################################################################
; ######## ##    ## ########  ########     #########################################################################################################################################################################################################
;                                          #########################################################################################################################################################################################################
; ##################################################################################################################################################################################################################################################
; ##################################################################################################################################################################################################################################################

Exit 0
