@echo off
REM ##################################################################################################
REM Sichern von FTP-Verzeichnissen per Batch-Datei
REM Dieses Script ldt das komplette Verzeichnis herunter,
REM Packt das heruntergeladene Verzeichnis in ein Archiv,
REM Sendet eine Email mit Status Erfolge oder Fehlgeschlagen + Log-Datei an gewnschten Empfnger
REM 
REM In dr Konfiguration wie hier wird das Arbeitsverzeichnis nicht gelscht.
REM dadurch muss in jedem Durchgang nicht alles heruntergeladen werden sondern es wird nur abgeglichen.
REM Die Archive enthalten aber immer alle kompletten Daten fr den Durchlauf.
REM
REM Diese Script bentigt noch folgende Zusatzprogramme:
REM WGET, WinRar oder 7zip, SendEmail
REM 
REM Weblinks zu den Programmen (Stand 11.05.2012):
REM WGET:       http://www.gnu.org/software/wget/
REM WinRar:     http://www.winrar.de/
REM 7zip:       http://www.7-zip.de/
REM SendEmail:  http://caspian.dotconf.net/menu/Software/SendEmail/

REM Mai 2012 von Bernhard Linz
REM Bernhard@znil.net
REM Bernhard.Linz@datagroup.de
REM verffentlicht auf znilwiki: http://znil.net
REM ##################################################################################################
REM ##################################################################################################

REM Benutzername und Passwort fr die FTP-Anmeldung
SET FTPBENUTZER=wgetbenutzer
SET FTPPASSWORT=YJFgpfJKx5r58GaRRLpseL
REM Welche Textdatei enthlt die Namen der FTP-Ordner die gesichert werden sollen?
REM Hinweis: Ein Host + Ordner pro Zeile, keine leeren Zeilen (auch nicht am Ende!)
REM Beispiel: ftp://ftp.meinserver.local/Verzeichnis/
SET FTPFOLDERDATEI=C:\Skripts\ftp_folders.txt
REM ##################################################################################################
REM ##################################################################################################

REM Wo soll das Arbeitsverzeichnis liegen? Wenn hierfr keine Datum+Uhrzeits gewhlt wird, wird das Verzeichnis bei jedem Durchlauf nur abgeglichen (=schneller)
REM Pfad immer ohne Abschliessendes \ !!!! BACKUPPFAD muss Unterverzeichnis sein, nie Laufwerk direkt nehmen
SET BACKUPLAUFWERK=C:
SET BACKUPPFAD=\WEB-BACKUPS

REM Wie soll das Archiv heissen (inklusive Pfad)?
REM An den Nachfolgenden Pfad und Namen wird dann noch Datum+Uhrzeit (wenn gewhlt) + .rar/.7z/.zip angehngt
REM aus M:\WEB-BACKUPS\znil.net wird also M:\WEB-BACKUPS\znil.net-2012-05-11-20-13.rar (oder .7z / .zip)
SET ARCHIVPFADUNDNAME=M:\WEB-BACKUPS\znil.net

REM Auswahl des Archiv-Packers / Typ
REM 
REM RAR = .rar = WinRar (Pfad zur rar.exe muss im Script angepasst werden oder WinRar-Verzeichnis in Path-Variable aufnehmen)
REM 7z  = .7z  = 7zip   (Pfad zur 7z.exe muss im Script angepasst werden oder 7zip-Verzeichnis in Path-Variable aufnehmen)
REM ZIP = .zip = ZIP    (Pfad zur 7z.exe muss im Script angepasst werden oder 7zip-Verzeichnis in Path-Variable aufnehmen)
SET ARCHIVTYP=7z

REM Pfade zu rar.exe und/oder 7z.exe, sendemail und wget -> nach Bedarf anpassen.
REM Falls die Verzeichnisse in der %PATH% Variablen stehen entfernen sie alles bis auf die eigentliche EXE Datei
SET wgetEXE="C:\Program Files (x86)\GnuWin32\bin\wget.exe"
SET sevenzipEXE="C:\Program Files\7-Zip\7z.exe"
SET rarEXE="C:\Program Files\WinRAR\rar.exe"
SET sendemailEXE="C:\Program Files (x86)\sendEmail-v156\sendemail.exe"
REM wegtEXE=wget.exe
REM sevenzipEXE=7z.exe
REM rarEXE=rar.exe
REM sendemailEXE=sendemail.exe

REM Absender und Empfnger der Status-Email,
REM die LOG-Datei und ob es Fehler gab wird per Email versendet
SET MAILFROM=WGET@znil.org
SET MAILLOGTO=bernhard@znil.de

REM wie heisst der SMTP-Server?
REM Achtung, sendemail ist nicht IPv6 fhig - nicht localhost oder 127.0.0.1 verwenden auf Vista/W7/2008(R2)!
SET SMTPSERVER=192.168.1.80

REM Soll im Arbeitsverzeichnis ein Ordner pro Sicherung mit Datum/Uhrzeit verwendet werden? Wenn NEIN wird nicht jedesmal alles kopiert sondern der Ordner nur aktualisiert
REM unbedingt empfohlen NEIN zu nehmen!
SET BENUTZE_DATUM_UHRZEIT_BACKUPPFAD=NEIN

REM Sollen fr die Archive an die Dateinamen Datum und Uhrzeit angehngt werden?
REM Unbedingt empfohlen JA zu nehmen!
SET BENUTZE_DATUM_UHRZEIT_RARPFAD=JA
SET DATUM_ZEIT_BKP=
SET DATUM_ZEIT_ARCHIV=

REM ##################################################################################################
REM ##################################################################################################
REM Begin des eigentlichen Scripts!
REM ##################################################################################################
REM ##################################################################################################
REM Aktuelles Datum / Zeit ermitteln und in eine fr Dateinamen passende Form bringen
REM Schreibweise ist jjjj-mm-tt-mm-hh-ss
setlocal enabledelayedexpansion
SET DATUM_ZEIT=%date:~-4%-%date:~-7,2%-%date:~-10,2%-%time:~-11,2%-%time:~-8,2%-%time:~-5,2%
SET DATUM_ZEIT=!DATUM_ZEIT:^ =0!
setlocal disabledelayedexpansion
IF "%BENUTZE_DATUM_UHRZEIT_BACKUPPFAD%" == "JA" SET DATUM_ZEIT_BKP=\%DATUM_ZEIT%
IF "%BENUTZE_DATUM_UHRZEIT_RARPFAD%" == "JA" SET DATUM_ZEIT_ARCHIV=%DATUM_ZEIT%
SET LOGFILE="%TEMP%\WGET-%DATUM_ZEIT%.txt"
SET LOGFILEGEPACKT="%TEMP%\WGET-%DATUM_ZEIT%"
REM Logfile anlegen (im TEMP-Ordner des Benutzers), lschen wir am Ende wieder
ECHO %DATE% - %TIME% >%LOGFILE%

REM Wenn eines der Programme einen Fehler zurckgibt wirde diese Variable auf JA gesetzt.
REM wird beim versenden der Email ausgewertet fr den passenden Betreff
SET GABESFEHLER=NEIN

REM **************************************************************************
REM die mit SET FTPFOLDERDATEI=... oben angegebene Textdatei Zeilenweise einlesen und verarbeiten.
for /F "eol=# tokens=1" %%i in (%FTPFOLDERDATEI%) do call :SCHLEIFE %%i

REM Aufruf der Verzeichniss direkt in diesr Batch, ohne externe Datei mit Liste,
REM Dazu oben das for /F .... auskommentieren und hier fr jede FTP-Verzeichnis eine Zeile einfgen
REM CALL :SCHLEIFE ftp://ftp.domain.local/znilwiki-webftp/
REM CALL :SCHLEIFE ftp://ftp.domain.local/mysqldumper/
GoTo VERPACKEN

REM **************************************************************************
:SCHLEIFE
%wgetEXE% --user=%FTPBENUTZER% --password=%FTPPASSWORT% -P"%BACKUPLAUFWERK%%BACKUPPFAD%%DATUM_ZEIT_BKP%" -m "%1" >>%LOGFILE% 2>&1
IF NOT ERRORLEVEL 0 SET GABESFEHLER=JA
GOTO :EOF

REM **************************************************************************
:VERPACKEN
REM WinRar Version (Shareware)(im Verzeichnis in das WinRar installiert wurde gibt es die rar.exe fr Commandline)
IF "%ARCHIVTYP%" == "RAR" %rarEXE% a %ARCHIVPFADUNDNAME%-%DATUM_ZEIT_ARCHIV%.rar -ri1 -m5 "%BACKUPLAUFWERK%%BACKUPPFAD%%DATUM_ZEIT_BKP%" >>%LOGFILE% 2>&1
REM 7zip Version (Kostenlos)(im Verzeichnis in das 7zip Installiert wurde gibt es die 7z.exe fr Commandline, Achtung richte Version fr BS installieren (x32 oder x64))
REM 7zip Archiv erzeugen (kleiner und damit besser als .rar und .zip)
IF "%ARCHIVTYP%" == "7z" %sevenzipEXE% a -mx9 -r -t7z %ARCHIVPFADUNDNAME%-%DATUM_ZEIT_ARCHIV%.7z "%BACKUPLAUFWERK%%BACKUPPFAD%%DATUM_ZEIT_BKP%\*.*" >>%LOGFILE% 2>&1
REM normales ZIP Archiv erzeugen (grer als .7zip oder .rar)
IF "%ARCHIVTYP%" == "ZIP" %sevenzipEXE% a -mx9 -r -tzip %ARCHIVPFADUNDNAME%-%DATUM_ZEIT_ARCHIV%.zip "%BACKUPLAUFWERK%%BACKUPPFAD%%DATUM_ZEIT_BKP%\*.*" >>%LOGFILE% 2>&1
REM auf Fehler prfen (Rckgabewert der EXE-Dateien ungleich 0)
IF NOT ERRORLEVEL 0 SET GABESFEHLER=JA
GoTo ENDE

REM **************************************************************************
:ENDE
REM Logfile packen bevor wir es an die Email anhngen,
REM wird sonst auch oft sehr gro - aber gut zu packen (10MByte auf wenige hundert Kilobyte)
IF "%ARCHIVTYP%" == "RAR" (
	SET LOGFILEGEPACKT=%LOGFILEGEPACKT%.rar
	%rarEXE% a %LOGFILEGEPACKT% -ri1 -m5 %LOGFILE%
) ELSE IF "%ARCHIVTYP%" == "7z" (
	SET LOGFILEGEPACKT=%LOGFILEGEPACKT%.7z
	%sevenzipEXE% a -mx9 -t7z %LOGFILEGEPACKT% %LOGFILE%
) ELSE IF "%ARCHIVTYP%" == "ZIP" (
	SET LOGFILEGEPACKT=%LOGFILEGEPACKT%.zip
	%sevenzipEXE% a -mx9 -tzip %LOGFILEGEPACKT%.zip %LOGFILE%
)
REM Email versenden mit passenden Betreff
IF "%GABESFEHLER%" == "JA" %sendemailEXE% -f %MAILFROM% -t %MAILLOGTO% -u "WGET FTP-Backup - FEHLER!" -m "Fehler siehe Log-Datei im Anhang" -s %SMTPSERVER% -a %LOGFILEGEPACKT%
IF "%GABESFEHLER%" == "NEIN" %sendemailEXE% -f %MAILFROM% -t %MAILLOGTO% -u "WGET FTP-Backup - ERFOLGREICH!" -m "Details siehe Log-Datei im Anhang" -s %SMTPSERVER% -a %LOGFILEGEPACKT%
REM Aufrumen - Logfile lschen
DEL %LOGFILE%
DEL %LOGFILEGEPACKT%


