#!/bin/bash
#
# Wochenenden und Feiertage
#
# 2016 Bernhard Linz
# http://znil.net 
#
# Ostermontagsformel hier gefunden: http://debianforum.de/forum/viewtopic.php?f=34&t=144038
#
# Aufruf:
#
# znil-WuF.sh [Parameter]
#
# Parameter sind:
#
# Weekend             gibt 1 zurück wenn es Samstag oder Sonntag ist, sonst 0
# Weekday             gibt den Wochentag als Zahl zurück, 1=Montag bis 7=Sonntag
# Saturday            gibt 1 zurück wenn es Samstag ist, sonst 0
# Sunday              gibt 1 zurück wenn es Sonntag ist, sonst 0
# PublicHoliday       gibt folgendes zurück:
#                                            0 ⇒ Kein Feiertag
#                                            1 ⇒ Neujahr
#                                            2 ⇒ Sylvester
#                                            3 ⇒ Maifeiertag
#                                            4 ⇒ Tag der Deutschen Einheit
#                                            5 ⇒ Reformationstag
#                                            6 ⇒ Allerheiligen
#                                            7 ⇒ Heiligabend
#                                            8 ⇒ 1. Weihnachtsfeiertag
#                                            9 ⇒ 2. Weihnachtsfeiertag
#                                           10 ⇒ Rosenmontag
#                                           11 ⇒ Karfreitag
#                                           12 ⇒ Ostersonntag
#                                           13 ⇒ Ostermontag
#                                           14 ⇒ Christi Himmelfahrt
#                                           15 ⇒ Pfingstsonntag
#                                           16 ⇒ Pfingstmontag
#                                           17 ⇒ Fronleichnam
#
#
# $1 = [Paramter]
#
# Test ob wir gerade Wochenende haben (Samstag und Sonntag)
if [ "$1" = "Weekend" ]; then
	iDayofWeek=$(date +%u)
	case $iDayofWeek in
	[1-5]*)
		echo "0"
		;;
	[6-7]*)
		echo "1"
		;;
	esac
fi

# Rückgabe des Wochentags als Zahl
if [ "$1" = "Weekday" ]; then
	iDayofWeek=$(date +%u)
	echo $iDayofWeek
fi

# Test ob gerade Samstag ist
if [ "$1" = "Saturday" ]; then
	iDayofWeek=$(date +%u)
	if [ "$iDayofWeek" = "6" ]; then
		echo "1"
	else
		echo "0"
	fi
fi

# Test ob gerade Sonntag ist
if [ "$1" = "Sunday" ]; then
	iDayofWeek=$(date +%u)
	if [ "$iDayofWeek" = "7" ]; then
		echo "1"
	else
		echo "0"
	fi
fi

# Test ob ein gesetzlicher Feiertag ist (+Heiligabend und Sylvester)
if [ "$1" = "PublicHoliday" ]; then
	iDayofWeek=$(date +%u)
	iDay=$(date +%d)
	iMonth=$(date +%m)
	iYearLong=$(date +%Y)
	iYearShort=$(date +%y)
	sDayMonth="$iDay-$iMonth"
	# Prüfung der festehenden Tage
	# TEST
	#if [ "$iDay" = "01" ] && [ "$iMonth" = "07" ]; then
	#	echo "1"
	#	exit 0
	#fi

	# Neujahr
	if [ "$iDay" = "01" ] && [ "$iMonth" = "01" ]; then
		echo "1"
		exit 0
	fi
	# Sylvester
	if [ "$iDay" = "31" ] && [ "$iMonth" = "12" ]; then
		echo "2"
		exit 0
	fi
	# 1. Mai
	if [ "$iDay" = "01" ] && [ "$iMonth" = "05" ]; then
		echo "3"
		exit 0
	fi
	# Tag der Deutschen Einheit
	if [ "$iDay" = "03" ] && [ "$iMonth" = "10" ]; then
		echo "4"
		exit 0
	fi
	# Reformationstag
	if [ "$iDay" = "31" ] && [ "$iMonth" = "10" ]; then
		echo "5"
		exit 0
	fi
	# Allerheiligen
	if [ "$iDay" = "01" ] && [ "$iMonth" = "11" ]; then
		echo "6"
		exit 0
	fi
	# Heiligabend
	if [ "$iDay" = "24" ] && [ "$iMonth" = "12" ]; then
		echo "7"
		exit 0
	fi
	# 1. Weihnachtsfeiertag
	if [ "$iDay" = "25" ] && [ "$iMonth" = "12" ]; then
		echo "8"
		exit 0
	fi
	# 2. Weihnachtsfeiertag
	if [ "$iDay" = "26" ] && [ "$iMonth" = "12" ]; then
		echo "9"
		exit 0
	fi
	# Ok, müssen wir doch noch auf die Osterformel zurück greifen...
	iYearLong=$(date +%Y); [ "$1" ] && [ "$1" = "${1//[^0-9]}" ] && [ $1 -ge 1902 -a $1 -le 8202 ] && iYearLong=$1
	#echo "${J}:"
	
	a=$(( $iYearLong % 19 ))
	b=$(( $iYearLong % 4 ))
	c=$(( $iYearLong % 7 ))
	m=$((( (8 * ($iYearLong / 100) + 13) / 25) - 2 ))
	s=$(( ($iYearLong / 100) - ($iYearLong / 400) - 2 ))
	M=$(( (15 + $s - $m) % 30 ))
	N=$(( (6 + $s) % 7 ))
	d=$(( ($M + 19 * $a) % 30 ))
	if [ $d = 29 ]; then
		D=28
	elif [ $d = 28 -a $a -ge 11 ]; then
		D=27
	else
		D=$d
	fi
	e=$(( (2 * $b + 4 * $c + 6 * $D + $N) % 7 ))
	Ostern=$( date -d ${iYearLong}-03-21+$(($D + $e + 1))days +%Y-%m-%d )
	
	#for t in "-48 Rosenmontag" "-2 Karfreitag" "+0 Ostersonntag" "+1 Ostermontag" "+39 Christi Himmelfahrt" "+49 Pfingstsonntag" "+50 Pfingstmontag" "+60 Fronleichnam"; do
	#	echo "$( date -d ${o}${t%% *}days "+%d.%m." ) ${t#* }"
	#done
	
	#echo $sDayMonth
	Rosenmontag=$( date -d ${Ostern}-48days "+%d-%m" )
	Karfreitag=$( date -d ${Ostern}-2days "+%d-%m" )
	Ostersonntag=$( date -d ${Ostern}+0days "+%d-%m" )
	Ostermontag=$( date -d ${Ostern}+1days "+%d-%m" )
	ChristiHimmelfahrt=$( date -d ${Ostern}+39days "+%d-%m" )
	Pfingstsonntag=$( date -d ${Ostern}+49days "+%d-%m" )
	Pfingstmontag=$( date -d ${Ostern}+50days "+%d-%m" )
	Fronleichnam=$( date -d ${Ostern}+60days "+%d-%m" )
	#echo "Ostern:               $Ostern"
	#echo "Rosenmontag:          $Rosenmontag"
	#echo "Karfreitag:           $Karfreitag"
	#echo "Ostersonntag:         $Ostersonntag"
	#echo "Ostermontag:          $Ostermontag"
	#echo "ChristiHimmelfahrt:   $ChristiHimmelfahrt"
	#echo "Pfingstsonntag:       $Pfingstsonntag"
	#echo "Pfingstmontag:        $Pfingstmontag"
	#echo "Fronleichnam:         $Fronleichnam"
	if [ "sDayMonth" = "$Rosenmontag" ]; then
		echo "10"
		exit 0
	fi
	if [ "sDayMonth" = "$Karfreitag" ]; then
		echo "11"
		exit 0
	fi
	if [ "sDayMonth" = "$Ostersonntag" ]; then
		echo "12"
		exit 0
	fi
	if [ "sDayMonth" = "$Ostermontag" ]; then
		echo "13"
		exit 0
	fi
	if [ "sDayMonth" = "$ChristiHimmelfahrt" ]; then
		echo "14"
		exit 0
	fi
	if [ "sDayMonth" = "$Pfingstsonntag" ]; then
		echo "15"
		exit 0
	fi
	if [ "sDayMonth" = "$Pfingstmontag" ]; then
		echo "16"
		exit 0
	fi
	if [ "sDayMonth" = "$Fronleichnam" ]; then
		echo "17"
		exit 0
	fi

	echo "0"
fi

exit 0
